/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import bsh.Interpreter;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.exec.ClientExecutor;
import com.sun.xml.ws.test.model.TestClient;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class ConcurrentClientExecutor
extends ClientExecutor {
    public static final int THREAD_COUNT = 20;
    public static final int REQUESTS = 50000;

    public ConcurrentClientExecutor(DeploymentContext context, TestClient client) {
        super(context, client);
    }

    @Override
    protected void invoke(final Interpreter engine) throws Throwable {
        ExecutorService service = this.createExecutorService();
        final Vector errors = new Vector();
        for (int i = 0; i < 50000 && errors.isEmpty(); ++i) {
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConcurrentClientExecutor.super.invoke(engine);
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            });
        }
        service.shutdown();
        while (!service.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
        if (!errors.isEmpty()) {
            System.out.printf("Found %d errors\n", errors.size());
        }
        for (Throwable error : errors.subList(0, Math.min(errors.size(), 20))) {
            error.printStackTrace();
        }
        if (!errors.isEmpty()) {
            throw (Throwable)errors.get(0);
        }
    }

    protected abstract ExecutorService createExecutorService();

    public static final class Cached
    extends ConcurrentClientExecutor {
        public Cached(DeploymentContext context, TestClient client) {
            super(context, client);
        }

        @Override
        protected ExecutorService createExecutorService() {
            return Executors.newCachedThreadPool();
        }
    }

    public static final class Fixed
    extends ConcurrentClientExecutor {
        public Fixed(DeploymentContext context, TestClient client) {
            super(context, client);
        }

        @Override
        protected ExecutorService createExecutorService() {
            return Executors.newFixedThreadPool(20);
        }
    }
}

