/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.World;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.exec.Executor;
import com.sun.xml.ws.test.model.TestEndpoint;
import com.sun.xml.ws.test.util.ArgumentListBuilder;
import com.sun.xml.ws.test.util.JavacTask;
import com.sun.xml.ws.test.util.WSITUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeploymentExecutor
extends Executor {
    private final DeployedService context;

    public DeploymentExecutor(DeployedService context) {
        super("Deploy " + context.service.name, context.parent);
        this.context = context;
    }

    @Override
    public void runTest() throws Throwable {
        CodeGenerator.testStarting(this.context.workDir);
        this.context.app = this.context.parent.container.deploy(this.context);
        if (!this.context.service.isSTS) {
            this.generateClientArtifacts();
        } else {
            this.addSTSToClasspath();
            this.updateWsitClient();
        }
    }

    public void updateWsitClient() throws Exception {
        File wsitClientFile = new File(this.context.parent.getResources(), "wsit-client.xml");
        if (!wsitClientFile.exists()) {
            throw new RuntimeException("wsit-client.xml is absent. It is required. \nPlease check " + String.valueOf(this.context.service.parent.resources));
        }
        URI uri = this.context.app.getEndpointAddress((TestEndpoint)this.context.service.endpoints.toArray()[0]);
        WSITUtil.updateWsitClient(wsitClientFile, uri.toString(), this.context.service.wsdl.get((int)0).wsdlFile.toURI().toString());
    }

    public void addSTSToClasspath() throws Exception {
        List<URL> classpath = this.context.clientClasspaths;
        ClassLoader baseCl = World.runtime.getClassLoader();
        if (this.context.parent.clientClassLoader != null) {
            baseCl = this.context.parent.clientClassLoader;
        }
        classpath.add(new File(this.context.warDir, "WEB-INF/classes").toURL());
        this.context.parent.clientClassLoader = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), baseCl);
    }

    private void generateClientArtifacts() throws Exception {
        File gensrcDir = this.makeWorkDir("client-source");
        File classDir = this.makeWorkDir("client-classes");
        for (int i = 0; i < this.context.app.getWSDL().size(); ++i) {
            URL wsdl = this.context.app.getWSDL().get(i);
            ArgumentListBuilder options = new ArgumentListBuilder();
            if (!this.context.service.parent.testOptions.contains("-noPackage") && !this.context.service.parent.wsimportClientOptions.contains("-p")) {
                if (i > 0) {
                    options.add("-p").add(this.context.parent.descriptor.name + ".client" + (i + 1));
                } else {
                    options.add("-p").add(this.context.parent.descriptor.name + ".client");
                }
            }
            options.add("-extension");
            for (File custFile : this.context.parent.descriptor.clientCustomizations) {
                options.add("-b").add(custFile);
            }
            if (World.debug) {
                options.add("-verbose");
            }
            options.add("-s").add(gensrcDir);
            options.add("-d").add(classDir);
            options.add("-Xnocompile");
            if (Boolean.getBoolean("harness.useSSL")) {
                options.add("-XdisableSSLHostnameVerification");
            }
            options.add(wsdl);
            if (World.debug) {
                System.out.println("wsdl = " + String.valueOf(wsdl));
            }
            options.addAll(this.context.service.parent.wsimportClientOptions);
            options.invoke(this.context.parent.wsimport);
        }
        JavacTask javac = new JavacTask(this.context.parent.descriptor.javacOptions);
        javac.setSourceDir(gensrcDir, this.context.parent.descriptor.common, new File(this.context.parent.descriptor.home, "client"));
        javac.setDestdir(classDir);
        javac.setDebug(true);
        if (!this.context.parent.wsimport.isNoop()) {
            javac.execute();
        }
        List<URL> classpath = this.context.clientClasspaths;
        classpath.add(classDir.toURL());
        classpath.add(new File(this.context.warDir, "WEB-INF/classes").toURL());
        if (this.context.getResources() != null) {
            classpath.add(this.context.getResources().toURL());
        }
        if (this.context.parent.clientClassLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.context.parent.clientClassLoader).getURLs();
            classpath.addAll(Arrays.asList(urls));
        }
        URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[classpath.size()]), World.runtime.getClassLoader());
        this.context.parent.clientClassLoader = cl;
        ArrayList<String> serviceClazzNames = new ArrayList<String>();
        this.findServiceClass(gensrcDir, serviceClazzNames);
        if (serviceClazzNames.isEmpty()) {
            System.out.println("WARNING: Cannot find the generated 'service' class that extends from jakarta.xml.ws.Service. Assuming provider-only service");
        }
        for (String name : serviceClazzNames) {
            this.context.serviceClass.add(cl.loadClass(name));
        }
    }

    public Executor createUndeployer() {
        return new Executor("Undeploy " + this.context.service.name, this.context.parent){

            @Override
            public void runTest() throws Throwable {
                CodeGenerator.testStarting(this.context.workDir);
                if (DeploymentExecutor.this.context.app != null) {
                    DeploymentExecutor.this.context.app.undeploy();
                }
            }
        };
    }

    private void findServiceClass(File dir, List<String> result) throws Exception {
        block0: for (File child : dir.listFiles()) {
            String line;
            if (child.isDirectory()) {
                this.findServiceClass(child, result);
                continue;
            }
            if (!child.getName().endsWith(".java")) continue;
            BufferedReader reader = new BufferedReader(new FileReader(child));
            String pkg = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("package ")) {
                    pkg = line.substring(8, line.indexOf(59));
                }
                if (!line.contains("extends Service")) continue;
                reader.close();
                String className = child.getName();
                className = className.substring(0, className.lastIndexOf(46));
                result.add(pkg + "." + className);
                continue block0;
            }
            reader.close();
        }
    }
}

