/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.exec;

import com.sun.istack.test.VersionNumber;
import com.sun.istack.test.VersionProcessor;
import com.sun.xml.ws.test.CodeGenerator;
import com.sun.xml.ws.test.container.DeployedService;
import com.sun.xml.ws.test.container.DeploymentContext;
import com.sun.xml.ws.test.exec.Executor;
import com.sun.xml.ws.test.model.TestEndpoint;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class JavaClientExecutor
extends Executor {
    private final String testClassName;
    private final File testSourceFile;
    private final int testCount;
    private final boolean skipTest;

    public JavaClientExecutor(DeploymentContext context, File sourceFile, VersionNumber version) throws IOException {
        super(JavaClientExecutor.cutExtension(sourceFile.getName()), context);
        String line;
        this.testSourceFile = sourceFile;
        String packageName = null;
        int count = 0;
        BufferedReader in = new BufferedReader(new FileReader(this.testSourceFile));
        VersionProcessor versionProcessor = null;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("package ")) {
                line = line.substring("package ".length());
                packageName = line.substring(0, line.indexOf(59));
            }
            if (line.startsWith("@VersionRequirement") || line.startsWith("@com.sun.xml.ws.test.VersionRequirement")) {
                versionProcessor = new VersionProcessor(this.grabAttributeValue(line, "since"), this.grabAttributeValue(line, "until"), this.grabAttributeValue(line, "excludeFrom"));
            }
            if (!line.startsWith("public void test")) continue;
            ++count;
        }
        this.testClassName = packageName + "." + JavaClientExecutor.cutExtension(sourceFile.getName());
        if (version != null && versionProcessor != null && !versionProcessor.isApplicable(version)) {
            this.skipTest = true;
            this.testCount = 0;
        } else {
            this.skipTest = false;
            this.testCount = count;
        }
    }

    private String grabAttributeValue(String str, String attr) {
        String patternStr = attr + "\\s*=\\s*\"(.+?)\"";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String cutExtension(String name) {
        int idx = name.lastIndexOf(46);
        name = name.substring(0, idx);
        return name;
    }

    public int countTestCases() {
        return this.testCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestResult result) {
        CodeGenerator.testStarting(this.context.workDir);
        if (this.skipTest) {
            System.out.printf("Version Requirement not satisfied, Skipping Test" + this.testClassName, new Object[0]);
            return;
        }
        if (this.context.clientClassLoader == null) {
            this.failAll(result, "this test is skipped because of other failures", null);
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.context.clientClassLoader);
        try {
            TestSuite ts;
            try {
                Map<String, String> injectedProperties = this.injectResources();
                Class<?> testClass = this.context.clientClassLoader.loadClass(this.testClassName);
                ts = new TestSuite(testClass);
                CodeGenerator.generateJUnitClient(ts, testClass, injectedProperties);
                for (int i = 0; i < ts.testCount(); ++i) {
                    Test t = ts.testAt(i);
                    this.inject(t);
                }
            }
            catch (Exception e) {
                this.failAll(result, "failed to prepare JUnit test class " + this.testClassName, e);
                Thread.currentThread().setContextClassLoader(cl);
                return;
            }
            ts.run(result);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public void runTest() throws Throwable {
        throw new AssertionError();
    }

    private void failAll(TestResult result, final String msg, final Exception error) {
        for (int i = 0; i < this.testCount; ++i) {
            new TestCase(this.testClassName){

                protected void runTest() throws Exception {
                    System.out.println(msg);
                    throw new Exception(msg, error);
                }
            }.run(result);
        }
    }

    private boolean hasWebServiceRef(Field f) {
        for (Annotation a : f.getAnnotations()) {
            if (!a.annotationType().getName().equals("jakarta.xml.ws.WebServiceRef")) continue;
            return true;
        }
        return false;
    }

    private void inject(Object o) throws Exception {
        block0: for (Field f : o.getClass().getFields()) {
            if (!this.hasWebServiceRef(f)) continue;
            Class<?> type = f.getType();
            for (DeployedService svc : this.context.services.values()) {
                for (Class clazz : svc.serviceClass) {
                    if (type.isAssignableFrom(clazz)) {
                        f.set(o, clazz.newInstance());
                        continue block0;
                    }
                    for (Method method : clazz.getMethods()) {
                        if (!type.isAssignableFrom(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
                        f.set(o, method.invoke(clazz.newInstance(), new Object[0]));
                        continue block0;
                    }
                }
            }
        }
    }

    private Map<String, String> injectResources() throws Exception {
        StringBuilder addressList = new StringBuilder("injected addresses:");
        Properties properties = System.getProperties();
        HashMap<String, String> injectedProperties = new HashMap<String, String>();
        for (DeployedService svc : this.context.services.values()) {
            if (svc.service.isSTS) continue;
            for (Class clazz : svc.serviceClass) {
                String packageName = clazz.getPackage().getName();
                Method[] methods = clazz.getMethods();
                Class<Annotation> webendpointAnnotation = clazz.getClassLoader().loadClass("jakarta.xml.ws.WebEndpoint").asSubclass(Annotation.class);
                Method nameMethod = webendpointAnnotation.getDeclaredMethod("name", new Class[0]);
                for (Method method : methods) {
                    Annotation endpoint = method.getAnnotation(webendpointAnnotation);
                    if (endpoint == null || method.getParameterTypes().length != 0) continue;
                    String portName = (String)nameMethod.invoke((Object)endpoint, new Object[0]);
                    String varName = Introspector.decapitalize(portName);
                    try {
                        String key = varName + "Address";
                        String value = svc.app.getEndpointAddress(this.getEndpoint(svc, portName)).toString();
                        properties.setProperty(key, value);
                        injectedProperties.put(key, value);
                        addressList.append(' ').append(varName).append("Address");
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                }
            }
        }
        System.out.println(addressList);
        return injectedProperties;
    }

    private TestEndpoint getEndpoint(DeployedService svc, String portName) {
        for (TestEndpoint e : svc.service.endpoints) {
            if (e.portName == null || !e.portName.equals(portName)) continue;
            return e;
        }
        if (svc.service.endpoints.size() != 1) {
            throw new Error("Multiple ports are defined on '" + svc.service.name + "', yet ports are ambiguous. Please use @WebService/Provider(portName=)");
        }
        return (TestEndpoint)svc.service.endpoints.toArray()[0];
    }
}

