/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.test.util;

import com.sun.xml.ws.test.SourcesCollector;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FreeMarkerTemplate {
    Map root = new HashMap();
    String templateName;
    static Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
    private static Map<String, Template> templates = new HashMap<String, Template>();

    public FreeMarkerTemplate(String template) {
        this.templateName = template;
        if (!templates.containsKey(this.templateName)) {
            try {
                templates.put(this.templateName, cfg.getTemplate(this.templateName));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public FreeMarkerTemplate(String id, int scriptOrder, String workdir, String templateName) {
        this(templateName);
        this.root.put("serviceId", id != null ? id : "NULL");
        this.root.put("stage", scriptOrder);
        this.root.put("workdir", workdir);
    }

    public void put(String key, Object value) {
        this.root.put(key, value);
    }

    public void run(File output) throws Exception {
        try (FileWriter out = new FileWriter(output);){
            Template template = templates.get(this.templateName);
            template.process((Object)this.root, (Writer)out);
            out.flush();
        }
    }

    public String writeFile() {
        String workdir = (String)this.root.get("workdir");
        String stage = String.valueOf(this.root.get("stage"));
        return this.writeFileTo(workdir, stage + "-" + this.templateName);
    }

    public String writeFileTo(String dir, String filename) {
        String fullFileName = dir + "/" + filename;
        SourcesCollector.ensureDirectoryExists(new File(fullFileName).getParent());
        System.out.println("\ngenerating file [" + fullFileName + "];\nparametersMap: [");
        Set entryset = this.root.entrySet();
        for (Map.Entry entry : entryset) {
            System.out.print("        ");
            System.out.print(entry.getKey());
            System.out.print(" : ");
            System.out.println(entry.getValue());
        }
        System.out.println("]\n");
        File f = new File(fullFileName);
        try {
            this.run(f);
        }
        catch (Exception t) {
            t.printStackTrace(System.out);
        }
        return f.getAbsolutePath();
    }

    static {
        cfg.setClassForTemplateLoading(FreeMarkerTemplate.class, "/com/sun/xml/ws/test/freemarker");
        cfg.setLocalizedLookup(false);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }
}

