/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.logging.Level;

public class SelectorFactory {
    protected static long timeout = 5000L;
    protected static int maxSelectors = 5;
    private static final Stack<Selector> selectors = new Stack();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Selector getSelector() {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            if (!initialized) {
                block16: {
                    try {
                        for (int i = 0; i < maxSelectors; ++i) {
                            selectors.add(SelectorFactory.createSelector());
                        }
                    }
                    catch (IOException ex) {
                        if (!SelectorThread.logger().isLoggable(Level.FINE)) break block16;
                        SelectorThread.logger().fine(ex.getMessage());
                    }
                }
                initialized = true;
            }
            Selector s = null;
            try {
                if (selectors.size() != 0) {
                    s = selectors.pop();
                }
            }
            catch (EmptyStackException ex) {
                // empty catch block
            }
            try {
                for (int attempts = 0; s == null && attempts < 2; ++attempts) {
                    if (SelectorThread.logger().isLoggable(Level.FINE)) {
                        SelectorThread.logger().fine("Running out of Selector. Pausing for:" + timeout);
                    }
                    selectors.wait(timeout);
                    try {
                        if (selectors.size() == 0) continue;
                        s = selectors.pop();
                        continue;
                    }
                    catch (EmptyStackException ex) {
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void returnSelector(Selector s) {
        Stack<Selector> stack = selectors;
        synchronized (stack) {
            selectors.push(s);
            if (selectors.size() == 1) {
                selectors.notify();
            }
        }
    }

    public static final void selectNowAndReturnSelector(Selector s) {
        try {
            s.selectNow();
            SelectorFactory.returnSelector(s);
        }
        catch (IOException e) {
            SelectorThread.logger().log(Level.WARNING, "Unexpected problem when releasing temporary Selector", e);
            try {
                s.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            try {
                SelectorFactory.reimburseSelector();
            }
            catch (IOException ee) {
                SelectorThread.logger().log(Level.WARNING, "Problematic Selector could not be reimbursed!", ee);
            }
        }
    }

    public static final void reimburseSelector() throws IOException {
        SelectorFactory.returnSelector(SelectorFactory.createSelector());
    }

    protected static Selector createSelector() throws IOException {
        return Selector.open();
    }
}

