/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet;

import com.sun.enterprise.web.connector.grizzly.NioProvider;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.comet.CometEngine;
import com.sun.enterprise.web.connector.grizzly.comet.CometTask;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometSelector {
    private long lastSpinTimestamp;
    private int emptySpinCounter;
    private static final int spinRateTreshold = 2000;
    static final boolean isLinux = System.getProperty("os.name").equalsIgnoreCase("linux") && !System.getProperty("java.version").startsWith("1.7");
    protected CometEngine cometEngine;
    private Selector selector;
    private Logger logger = SelectorThread.logger();
    private ConcurrentHashMap<SelectionKey, CometTask> keysToRegister = new ConcurrentHashMap();

    public CometSelector(CometEngine cometEngine) {
        this.cometEngine = cometEngine;
    }

    public void start() throws InterruptedException {
        final CountDownLatch isStartedLatch = new CountDownLatch(1);
        new Thread("CometSelector"){
            {
                super(x0);
                this.setDaemon(true);
            }

            public void run() {
                try {
                    CometSelector.this.selector = Selector.open();
                }
                catch (IOException ex) {
                    CometSelector.this.logger.log(Level.SEVERE, "CometSelector.open()", ex);
                    return;
                }
                isStartedLatch.countDown();
                while (true) {
                    SelectionKey key = null;
                    int selectorState = 0;
                    try {
                        CometTask cometTask;
                        long sr;
                        block20: {
                            selectorState = 0;
                            try {
                                selectorState = CometSelector.this.selector.select(1000L);
                            }
                            catch (CancelledKeyException ex) {
                                if (!CometSelector.this.logger.isLoggable(Level.FINEST)) break block20;
                                CometSelector.this.logger.log(Level.FINEST, "CometSelector.open()", ex);
                            }
                        }
                        Set<SelectionKey> readyKeys = CometSelector.this.selector.selectedKeys();
                        if (readyKeys.size() != 0 && isLinux) {
                            CometSelector.this.resetSpinCounter();
                        } else if (isLinux && (sr = (long)CometSelector.this.getSpinRate()) > 2000L) {
                            CometSelector.this.workaroundSelectorSpin();
                        }
                        Iterator<SelectionKey> iterator = readyKeys.iterator();
                        while (iterator.hasNext()) {
                            key = iterator.next();
                            iterator.remove();
                            if (key.isValid()) {
                                cometTask = (CometTask)key.attachment();
                                if (key.isReadable()) {
                                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                                    cometTask.upcoming_op = CometTask.OP_EVENT.READ;
                                }
                                if (key.isWritable()) {
                                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                                    cometTask.upcoming_op = CometTask.OP_EVENT.WRITE;
                                }
                                if (cometTask != null && cometTask.getSelectionKey() != null && cometTask.getSelectionKey().attachment() == null) {
                                    cometTask.execute();
                                    continue;
                                }
                                key.cancel();
                                continue;
                            }
                            CometSelector.this.cancelKey(key);
                        }
                        Iterator keys = CometSelector.this.keysToRegister.keySet().iterator();
                        while (keys.hasNext()) {
                            SelectionKey mainKey = (SelectionKey)keys.next();
                            SocketChannel channel = (SocketChannel)mainKey.channel();
                            if (!mainKey.isValid() || !channel.isOpen()) continue;
                            key = channel.register(CometSelector.this.selector, 1);
                            cometTask = (CometTask)CometSelector.this.keysToRegister.remove(mainKey);
                            cometTask.setCometKey(key);
                            key.attach(cometTask);
                            keys.remove();
                        }
                        CometSelector.this.expireIdleKeys();
                        if (selectorState > 0) continue;
                        CometSelector.this.selector.selectedKeys().clear();
                        continue;
                    }
                    catch (Throwable t) {
                        if (key != null) {
                            try {
                                CometSelector.this.cancelKey(key);
                            }
                            catch (Throwable t2) {
                                CometSelector.this.logger.log(Level.SEVERE, "CometSelector", t2);
                            }
                        }
                        if (selectorState <= 0) {
                            CometSelector.this.selector.selectedKeys().clear();
                        }
                        if (!CometSelector.this.logger.isLoggable(Level.FINEST)) continue;
                        CometSelector.this.logger.log(Level.FINEST, "CometSelector", t);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        isStartedLatch.await();
    }

    protected void expireIdleKeys() {
        Set<SelectionKey> readyKeys = this.selector.keys();
        if (readyKeys.isEmpty()) {
            return;
        }
        long current = System.currentTimeMillis();
        for (SelectionKey key : readyKeys) {
            CometTask cometTask = (CometTask)key.attachment();
            if (cometTask == null) {
                return;
            }
            if (cometTask.getExpirationDelay() == -1L) continue;
            long expire = cometTask.getExpireTime();
            if (current - expire >= cometTask.getExpirationDelay()) {
                this.cancelKey(key);
            }
            if (cometTask.getSelectionKey() == null || !(cometTask.getSelectionKey().attachment() instanceof Long)) continue;
            key.cancel();
            this.cometEngine.interrupt(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void cancelKey(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        try {
            CometTask cometTask = (CometTask)key.attachment();
            if (cometTask != null) {
                SelectorThread st = cometTask.getSelectorThread();
                SelectionKey mainKey = cometTask.getSelectionKey();
                if (cometTask.getCometContext() != null) {
                    cometTask.getCometContext().interrupt(cometTask);
                }
                this.cometEngine.interrupt(key);
                st.cancelKey(mainKey);
            } else {
                this.cometEngine.interrupt(key);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "CometSelector", t);
        }
        finally {
            key.attach(null);
        }
        key.cancel();
    }

    public void registerKey(SelectionKey key, CometTask cometTask) {
        if (key == null || cometTask == null || !key.isValid() || this.selector == null) {
            return;
        }
        cometTask.setExpireTime(System.currentTimeMillis());
        this.keysToRegister.put(key, cometTask);
        this.selector.wakeup();
    }

    public void wakeup() {
        this.selector.wakeup();
    }

    public SelectionKey cometKeyFor(SelectableChannel channel) {
        NioProvider nioP = NioProvider.getProvider();
        if (nioP == null) {
            return channel.keyFor(this.selector);
        }
        return nioP.keyFor(channel, this.selector);
    }

    public void resetSpinCounter() {
        this.emptySpinCounter = 0;
    }

    public int getSpinRate() {
        if (this.emptySpinCounter++ == 0) {
            this.lastSpinTimestamp = System.nanoTime();
        } else if (this.emptySpinCounter == 1000) {
            long deltatime = System.nanoTime() - this.lastSpinTimestamp;
            int contspinspersec = (int)(1000000000000L / deltatime);
            this.emptySpinCounter = 0;
            return contspinspersec;
        }
        return 0;
    }

    private void workaroundSelectorSpin() throws IOException {
        Selector newSelector = Selector.open();
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            try {
                key.channel().register(newSelector, key.interestOps(), key.attachment());
            }
            catch (Exception e) {}
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selector = newSelector;
    }
}

