/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public class WSAsyncListener {
    private final WSHTTPConnection con;
    private final HttpAdapter.CompletionCallback callback;
    private static final Logger LOGGER = Logger.getLogger(WSAsyncListener.class.getName());

    WSAsyncListener(WSHTTPConnection con, HttpAdapter.CompletionCallback callback) {
        this.con = con;
        this.callback = callback;
    }

    public void addListenerTo(AsyncContext context) {
        context.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent event) throws IOException {
                LOGGER.fine("WSAsyncListener completed");
                WSAsyncListener.this.callback.onCompletion();
            }

            public void onTimeout(AsyncEvent event) throws IOException {
                LOGGER.fine("WSAsyncListener timed out");
                WSAsyncListener.this.con.close();
            }

            public void onError(AsyncEvent event) throws IOException {
                LOGGER.fine("WSAsyncListener on error");
                WSAsyncListener.this.con.close();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                LOGGER.fine("WSAsyncListener on start async");
            }
        });
    }
}

