/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class AsyncReadTask
extends DefaultReadTask {
    public void initialize(StreamAlgorithm algorithm, boolean useDirectByteBuffer, boolean useByteBufferView) {
        super.initialize(algorithm, useDirectByteBuffer, useByteBufferView);
        this.byteBuffer = algorithm.allocate(useDirectByteBuffer, useByteBufferView, this.selectorThread.getBufferSize());
    }

    public void doTask() throws IOException {
        this.doTask(this.byteBuffer);
    }

    protected void manageKeepAlive(boolean keepAlive, int count, Exception exception) {
        if (count <= 0 || exception != null) {
            if (exception != null) {
                this.detachProcessor();
                if (SelectorThread.logger().isLoggable(Level.FINE)) {
                    SelectorThread.logger().log(Level.FINE, "SocketChannel Read Exception:", exception);
                }
            }
            this.terminate(false);
        }
    }

    public boolean executeProcessorTask() throws IOException {
        boolean registerKey = false;
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "executeProcessorTask");
        }
        if (this.algorithm.getHandler() != null && this.algorithm.getHandler().handle(null, 2) == 1) {
            return true;
        }
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        } else {
            this.configureProcessorTask();
        }
        if (this.taskEvent == null) {
            this.taskContext = new TaskContext();
            this.taskEvent = new TaskEvent<TaskContext>(this.taskContext);
        }
        this.taskEvent.setStatus(0);
        this.taskContext.setInputStream(this.inputStream);
        this.taskEvent.attach(this.taskContext);
        this.fireTaskEvent(this.taskEvent);
        return false;
    }

    public void recycle() {
        this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
        this.byteBuffer.clear();
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
    }

    public void setByteBuffer(ByteBuffer srcBB) {
        if (srcBB != this.byteBuffer) {
            if (srcBB.capacity() > this.byteBuffer.capacity()) {
                this.byteBuffer = this.algorithm.allocate(this.useDirectByteBuffer, this.useByteBufferView, srcBB.capacity());
            }
            srcBB.flip();
            this.byteBuffer.put(srcBB);
            srcBB.clear();
        } else {
            this.byteBuffer = srcBB;
        }
    }

    public void terminate(boolean keepAlive) {
        if (keepAlive) {
            this.processorTask.recycle();
            this.registerKey();
            this.returnTask();
        } else {
            if (this.processorTask != null) {
                ProcessorTask recycleProcessorTask = this.processorTask;
                if (recycleProcessorTask instanceof AsyncProcessorTask) {
                    recycleProcessorTask = ((AsyncProcessorTask)((Object)recycleProcessorTask)).getProcessorTask();
                }
                try {
                    if (recycleProcessorTask != null) {
                        recycleProcessorTask.postProcess();
                    }
                }
                catch (Exception e) {
                    SelectorThread.logger().log(Level.WARNING, "postProcess DefaultProcessorTask:", e);
                }
            }
            super.terminate(keepAlive);
        }
    }

    public void configureProcessorTask() {
        super.configureProcessorTask();
        if (!this.getTaskListeners().contains(this.processorTask)) {
            this.addTaskListener((TaskListener)((Object)this.processorTask));
        }
        if (!this.processorTask.getTaskListeners().contains(this)) {
            this.processorTask.addTaskListener(this);
        }
    }
}

