/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;

public final class LogStackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private static final long serialVersionUID = 6992337162326171013L;

    private LogStackTraceElement() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogStackTraceElement)) {
            return false;
        }
        LogStackTraceElement logStackTraceElement = (LogStackTraceElement)object;
        return logStackTraceElement.declaringClass.equals(this.declaringClass) && logStackTraceElement.lineNumber == this.lineNumber && LogStackTraceElement.eq(this.methodName, logStackTraceElement.methodName) && LogStackTraceElement.eq(this.fileName, logStackTraceElement.fileName);
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public int hashCode() {
        int n = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        n = 31 * n + (this.fileName == null ? 0 : this.fileName.hashCode());
        n = 31 * n + this.lineNumber;
        return n;
    }
}

