/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.logging.LogStackTraceElement;

public class LogThrowable
extends Throwable {
    private String detailMessage;
    private LogThrowable cause = this;
    private LogStackTraceElement[] stackTrace;

    public LogThrowable() {
        this.fillInStackTrace();
    }

    public LogThrowable(String string) {
        this.fillInStackTrace();
        this.detailMessage = string;
    }

    public LogThrowable(String string, LogThrowable logThrowable) {
        this.fillInStackTrace();
        this.detailMessage = string;
        this.cause = logThrowable;
    }

    public LogThrowable(LogThrowable logThrowable) {
        this.fillInStackTrace();
        this.detailMessage = logThrowable == null ? null : logThrowable.toString();
        this.cause = logThrowable;
    }

    public LogThrowable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public synchronized LogThrowable initCause(LogThrowable logThrowable) {
        if (this.cause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (logThrowable == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = logThrowable;
        return this;
    }

    private void printStackTraceAsCause(PrintStream printStream, LogStackTraceElement[] logStackTraceElementArray) {
        LogThrowable logThrowable;
        LogStackTraceElement[] logStackTraceElementArray2 = this.getOurStackTrace();
        int n = logStackTraceElementArray2.length - 1;
        int n2 = logStackTraceElementArray.length - 1;
        while (n >= 0 && n2 >= 0 && logStackTraceElementArray2[n].equals(logStackTraceElementArray[n2])) {
            --n;
            --n2;
        }
        int n3 = logStackTraceElementArray2.length - 1 - n;
        printStream.println("Caused by: " + this);
        int n4 = 0;
        while (n4 <= n) {
            printStream.println("\tat " + logStackTraceElementArray2[n4]);
            ++n4;
        }
        if (n3 != 0) {
            printStream.println("\t... " + n3 + " more");
        }
        if ((logThrowable = this.getCause()) != null) {
            logThrowable.printStackTraceAsCause(printStream, logStackTraceElementArray2);
        }
    }

    private void printStackTraceAsCause(PrintWriter printWriter, LogStackTraceElement[] logStackTraceElementArray) {
        LogThrowable logThrowable;
        LogStackTraceElement[] logStackTraceElementArray2 = this.getOurStackTrace();
        int n = logStackTraceElementArray2.length - 1;
        int n2 = logStackTraceElementArray.length - 1;
        while (n >= 0 && n2 >= 0 && logStackTraceElementArray2[n].equals(logStackTraceElementArray[n2])) {
            --n;
            --n2;
        }
        int n3 = logStackTraceElementArray2.length - 1 - n;
        printWriter.println("Caused by: " + this);
        int n4 = 0;
        while (n4 <= n) {
            printWriter.println("\tat " + logStackTraceElementArray2[n4]);
            ++n4;
        }
        if (n3 != 0) {
            printWriter.println("\t... " + n3 + " more");
        }
        if ((logThrowable = this.getCause()) != null) {
            logThrowable.printStackTraceAsCause(printWriter, logStackTraceElementArray2);
        }
    }

    public LogStackTraceElement[] getStackTrace() {
        return (LogStackTraceElement[])this.getOurStackTrace().clone();
    }

    private synchronized LogStackTraceElement[] getOurStackTrace() {
        if (this.stackTrace == null) {
            int n = this.getStackTraceDepth();
            this.stackTrace = new LogStackTraceElement[n];
            int n2 = 0;
            while (n2 < n) {
                this.stackTrace[n2] = this.getLogStackTraceElement(n2);
                ++n2;
            }
        }
        return this.stackTrace;
    }

    public void setStackTrace(LogStackTraceElement[] logStackTraceElementArray) {
        LogStackTraceElement[] logStackTraceElementArray2 = (LogStackTraceElement[])logStackTraceElementArray.clone();
        int n = 0;
        while (n < logStackTraceElementArray2.length) {
            if (logStackTraceElementArray2[n] == null) {
                throw new NullPointerException("stackTrace[" + n + "]");
            }
            ++n;
        }
        this.stackTrace = logStackTraceElementArray2;
    }

    private native int getStackTraceDepth();

    private native LogStackTraceElement getLogStackTraceElement(int var1);

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getOurStackTrace();
        objectOutputStream.defaultWriteObject();
    }
}

