/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import com.sun.xml.wss.provider.wsit.RegistrationContextImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigFactory;

final class EntryInfo {
    private final String className;
    private final Map<String, String> properties;
    private List<AuthConfigFactory.RegistrationContext> regContexts;

    EntryInfo(String className, Map<String, String> properties) {
        if (className == null) {
            throw new IllegalArgumentException("Class name for registration entry cannot be null");
        }
        this.className = className;
        this.properties = properties;
    }

    EntryInfo(String className, Map<String, String> properties, List<AuthConfigFactory.RegistrationContext> ctxs) {
        if (ctxs == null || ctxs.isEmpty()) {
            throw new IllegalArgumentException("Registration entry must contain one ormore registration contexts");
        }
        this.className = className;
        this.properties = properties;
        this.regContexts = ctxs;
    }

    EntryInfo(String className, Map<String, String> properties, AuthConfigFactory.RegistrationContext ctx) {
        this.className = className;
        this.properties = properties;
        if (ctx != null) {
            RegistrationContextImpl ctxImpl = new RegistrationContextImpl(ctx.getMessageLayer(), ctx.getAppContext(), ctx.getDescription(), ctx.isPersistent());
            ArrayList<AuthConfigFactory.RegistrationContext> newList = new ArrayList<AuthConfigFactory.RegistrationContext>(1);
            newList.add(ctxImpl);
            this.regContexts = newList;
        }
    }

    boolean isConstructorEntry() {
        return this.regContexts == null;
    }

    String getClassName() {
        return this.className;
    }

    Map<String, String> getProperties() {
        return this.properties;
    }

    List<AuthConfigFactory.RegistrationContext> getRegContexts() {
        return this.regContexts;
    }

    boolean equals(EntryInfo target) {
        if (target == null) {
            return false;
        }
        return !(this.isConstructorEntry() ^ target.isConstructorEntry()) && EntryInfo.matchStrings(this.className, target.getClassName()) && EntryInfo.matchMaps(this.properties, target.getProperties());
    }

    static boolean matchStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean matchMaps(Map m1, Map m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return ((Object)m1).equals(m2);
    }
}

