/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private LogManager manager = LogManager.getLogManager();
    private String name;
    private ArrayList handlers;
    private String resourceBundleName;
    private boolean useParentHandlers = true;
    private Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static Object treeLock = new Object();
    private Logger parent;
    private ArrayList kids;
    private Level levelObject;
    private volatile int levelValue;
    public static final Logger global = Logger.getLogger("global");

    protected Logger(String string, String string2) {
        if (string2 != null) {
            this.setupResourceInfo(string2);
        }
        this.name = string;
        this.levelValue = Level.INFO.intValue();
    }

    public static synchronized Logger getLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            logger = new Logger(string, null);
            logManager.addLogger(logger);
            logger = logManager.getLogger(string);
        }
        return logger;
    }

    public static synchronized Logger getLogger(String string, String string2) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            logger = new Logger(string, string2);
            logManager.addLogger(logger);
            logger = logManager.getLogger(string);
        }
        if (logger.resourceBundleName == null) {
            logger.setupResourceInfo(string2);
        } else if (!logger.resourceBundleName.equals(string2)) {
            throw new IllegalArgumentException(logger.resourceBundleName + " != " + string2);
        }
        return logger;
    }

    public static synchronized Logger getAnonymousLogger() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = new Logger(null, null);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public static synchronized Logger getAnonymousLogger(String string) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = new Logger(null, string);
        logger.anonymous = true;
        Logger logger2 = logManager.getLogger("");
        logger.doSetParent(logger2);
        return logger;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName());
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter filter) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Logger logger = this;
        synchronized (logger) {
            if (this.filter != null && !this.filter.isLoggable(logRecord)) {
                return;
            }
        }
        Logger logger2 = this;
        while (logger2 != null) {
            Handler[] handlerArray = logger2.getHandlers();
            if (handlerArray != null) {
                int n = 0;
                while (n < handlerArray.length) {
                    handlerArray[n].publish(logRecord);
                    ++n;
                }
            }
            if (!logger2.getUseParentHandlers()) break;
            logger2 = logger2.getParent();
        }
    }

    private void doLog(LogRecord logRecord) {
        logRecord.setLoggerName(this.name);
        String string = this.getEffectiveResourceBundleName();
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string));
        }
        this.log(logRecord);
    }

    public void log(Level level, String string) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void log(Level level, String string, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord);
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    private void doLog(LogRecord logRecord, String string) {
        logRecord.setLoggerName(this.name);
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string));
        }
        this.log(logRecord);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        Object[] objectArray = new Object[]{object};
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        this.doLog(logRecord, string3);
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(level, string4);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord, string3);
    }

    public void entering(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "ENTRY");
    }

    public void entering(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "ENTRY {0}", objectArray);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String string3 = "ENTRY";
        int n = 0;
        while (n < objectArray.length) {
            string3 = string3 + " {" + n + "}";
            ++n;
        }
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void exiting(String string, String string2) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, string, string2, "RETURN");
    }

    public void exiting(String string, String string2, Object object) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        this.logp(Level.FINER, string, string2, "RETURN {0}", object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        LogRecord logRecord = new LogRecord(Level.FINER, "THROW");
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThrown(throwable);
        this.doLog(logRecord);
    }

    public void severe(String string) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, string);
    }

    public void setLevel(Level level) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = level;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public synchronized void removeHandler(Handler handler) throws SecurityException {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this.handlers == null) {
            return;
        }
        ((AbstractCollection)this.handlers).remove(handler);
    }

    public synchronized Handler[] getHandlers() {
        if (this.handlers == null) {
            return emptyHandlers;
        }
        Handler[] handlerArray = new Handler[this.handlers.size()];
        handlerArray = this.handlers.toArray(handlerArray);
        return handlerArray;
    }

    public synchronized void setUseParentHandlers(boolean bl) {
        if (!this.anonymous) {
            this.manager.checkAccess();
        }
        this.useParentHandlers = bl;
    }

    public synchronized boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private synchronized ResourceBundle findResourceBundle(String string) {
        if (string == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        if (this.catalog != null && locale == this.catalogLocale && string == this.catalogName) {
            return this.catalog;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
            this.catalogName = string;
            this.catalogLocale = locale;
            return this.catalog;
        }
        catch (MissingResourceException missingResourceException) {
            Class clazz;
            int n = 0;
            while ((clazz = null) != null) {
                ClassLoader classLoader2 = clazz.getClassLoader();
                if (classLoader2 == null) {
                    classLoader2 = ClassLoader.getSystemClassLoader();
                }
                if (classLoader != classLoader2) {
                    classLoader = classLoader2;
                    try {
                        this.catalog = ResourceBundle.getBundle(string, locale, classLoader);
                        this.catalogName = string;
                        this.catalogLocale = locale;
                        return this.catalog;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                ++n;
            }
            if (string.equals(this.catalogName)) {
                return this.catalog;
            }
            return null;
        }
    }

    private synchronized void setupResourceInfo(String string) {
        if (string == null) {
            return;
        }
        ResourceBundle resourceBundle = this.findResourceBundle(string);
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find " + string + " bundle", string, "");
        }
        this.resourceBundleName = string;
    }

    public Logger getParent() {
        Object object = treeLock;
        synchronized (object) {
            Logger logger = this.parent;
            return logger;
        }
    }

    public void setParent(Logger logger) {
        if (logger == null) {
            throw new NullPointerException();
        }
        this.manager.checkAccess();
        this.doSetParent(logger);
    }

    private void doSetParent(Logger logger) {
        Object object = treeLock;
        synchronized (object) {
            if (this.parent != null) {
                Iterator iterator = ((AbstractList)this.parent.kids).iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    Logger logger2 = (Logger)weakReference.get();
                    if (logger2 != this) continue;
                    iterator.remove();
                    break;
                }
            }
            this.parent = logger;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            this.parent.kids.add(new WeakReference<Logger>(this));
            this.updateEffectiveLevel();
        }
    }

    private void updateEffectiveLevel() {
        int n = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == n) {
            return;
        }
        this.levelValue = n;
        if (this.kids != null) {
            int n2 = 0;
            while (n2 < this.kids.size()) {
                WeakReference weakReference = (WeakReference)this.kids.get(n2);
                Logger logger = (Logger)weakReference.get();
                if (logger != null) {
                    logger.updateEffectiveLevel();
                }
                ++n2;
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        Logger logger = this;
        while (logger != null) {
            String string = logger.getResourceBundleName();
            if (string != null) {
                return string;
            }
            logger = logger.getParent();
        }
        return null;
    }
}

