/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import com.sun.xml.bind.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlFactory {
    public static final Logger logger = Logger.getLogger(XmlFactory.class.getName());
    public static final boolean DISABLE_SECURE_PROCESSING = Boolean.parseBoolean(Util.getSystemProperty("com.sun.xml.bind.disableXmlSecurity"));

    private static boolean xmlFeatureValue(boolean runtimeSetting) {
        return !DISABLE_SECURE_PROCESSING && (DISABLE_SECURE_PROCESSING || !runtimeSetting);
    }

    public static final SchemaFactory createSchemaFactory(String language, boolean disableSecureProcessing) throws IllegalArgumentException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance(language);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SchemaFactory instance: {0}", factory);
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlFactory.xmlFeatureValue(disableSecureProcessing));
            return factory;
        }
        catch (SAXNotRecognizedException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
        catch (SAXNotSupportedException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    public static final SAXParserFactory createParserFactory(boolean disableSecureProcessing) throws IllegalArgumentException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SAXParserFactory instance: {0}", factory);
            }
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlFactory.xmlFeatureValue(disableSecureProcessing));
            return factory;
        }
        catch (ParserConfigurationException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
        catch (SAXNotRecognizedException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
        catch (SAXNotSupportedException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    public static final XPathFactory createXPathFactory(boolean disableSecureProcessing) throws IllegalArgumentException {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "XPathFactory instance: {0}", factory);
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlFactory.xmlFeatureValue(disableSecureProcessing));
            return factory;
        }
        catch (XPathFactoryConfigurationException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    public static final TransformerFactory createTransformerFactory(boolean disableSecureProcessing) throws IllegalArgumentException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TransformerFactory instance: {0}", factory);
            }
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlFactory.xmlFeatureValue(disableSecureProcessing));
            return factory;
        }
        catch (TransformerConfigurationException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }

    public static final DocumentBuilderFactory createDocumentBuilderFactory(boolean disableSecureProcessing) throws IllegalStateException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "DocumentBuilderFactory instance: {0}", factory);
            }
            factory.setNamespaceAware(true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", XmlFactory.xmlFeatureValue(disableSecureProcessing));
            return factory;
        }
        catch (ParserConfigurationException ex) {
            logger.log(Level.SEVERE, null, ex);
            throw new IllegalStateException(ex);
        }
    }
}

