/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.protocol.wsmc200702.MessagePendingElement;
import com.sun.xml.ws.rx.mc.runtime.MakeConnectionSenderTask;
import com.sun.xml.ws.rx.mc.runtime.McConfiguration;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import com.sun.xml.ws.rx.util.SuspendedFiberStorage;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

abstract class McResponseHandlerBase
extends AbstractResponseHandler
implements Fiber.CompletionCallback {
    private static final Logger LOGGER = Logger.getLogger(McResponseHandlerBase.class);
    protected final McConfiguration configuration;
    protected final MakeConnectionSenderTask mcSenderTask;

    protected McResponseHandlerBase(McConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage, String correlationId) {
        super(suspendedFiberStorage, correlationId);
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
    }

    protected McResponseHandlerBase(McConfiguration configuration, MakeConnectionSenderTask mcSenderTask, SuspendedFiberStorage suspendedFiberStorage) {
        super(suspendedFiberStorage, null);
        this.configuration = configuration;
        this.mcSenderTask = mcSenderTask;
    }

    protected final void processMakeConnectionHeaders(@NotNull Message responseMessage) throws RxRuntimeException {
        MessagePendingElement messagePendingHeader;
        assert (responseMessage != null);
        if (responseMessage.hasHeaders() && (messagePendingHeader = (MessagePendingElement)this.readHeaderAsUnderstood(responseMessage, this.configuration.getRuntimeVersion().protocolVersion.messagePendingHeaderName)) != null && messagePendingHeader.isPending().booleanValue()) {
            this.mcSenderTask.scheduleMcRequest();
        }
    }

    private final <T> T readHeaderAsUnderstood(Message message, QName headerName) throws RxRuntimeException {
        Header header = message.getHeaders().get(headerName, true);
        if (header == null) {
            return null;
        }
        try {
            Object result = header.readAsJAXB(this.configuration.getRuntimeVersion().getUnmarshaller(this.configuration.getAddressingVersion()));
            return result;
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RxRuntimeException(String.format("Error unmarshalling header %s", headerName), ex));
        }
    }
}

