/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.client.dii;

import com.sun.xml.rpc.client.dii.CallInvocationHandler;
import com.sun.xml.rpc.client.dii.ConfiguredCall;
import com.sun.xml.rpc.client.dii.PortInfo;
import com.sun.xml.rpc.client.dii.ServiceInfo;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerRegistry;

public class DynamicProxyBuilder {
    protected InternalTypeMappingRegistry internalTypeRegistry;
    protected HandlerRegistry handlerRegistry;
    protected ServiceInfo configuration;

    public DynamicProxyBuilder(InternalTypeMappingRegistry internalTypeRegistry, HandlerRegistry handlerRegistry, ServiceInfo configuration) {
        this.internalTypeRegistry = internalTypeRegistry;
        this.handlerRegistry = handlerRegistry;
        this.configuration = configuration;
    }

    public Remote buildDynamicProxyFor(PortInfo portInfo, Class portInterface) throws ServiceException {
        CallInvocationHandler handler = new CallInvocationHandler(portInterface);
        handler._setProperty("javax.xml.rpc.service.endpoint.address", portInfo.getTargetEndpoint());
        Method[] interfaceMethods = portInterface.getMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            Method currentMethod = interfaceMethods[i];
            if (!Modifier.isPublic(currentMethod.getModifiers())) continue;
            ConfiguredCall methodCall = new ConfiguredCall(this.internalTypeRegistry, this.handlerRegistry, this.configuration);
            String methodName = currentMethod.getName();
            methodCall.setPortName(portInfo.getName());
            methodCall.setOperationMethod(currentMethod);
            methodCall.setMethodName(methodName);
            methodCall.setIsProxy(true);
            handler.addCall(currentMethod, methodCall);
        }
        return (Remote)Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, Stub.class, Remote.class}, (InvocationHandler)handler);
    }
}

