/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.metro.api.config.management;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.metro.api.config.management.CommunicationServer;
import com.sun.xml.ws.metro.api.config.management.ConfigReader;
import com.sun.xml.ws.metro.api.config.management.ConfigSaver;
import com.sun.xml.ws.metro.api.config.management.Configurator;
import com.sun.xml.ws.metro.api.config.management.EndpointStarter;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementFactory {
    private static final Logger LOGGER = Logger.getLogger(ManagementFactory.class);
    private static final String DEFAULT_COMMUNICATION_SERVER_CLASS_NAME = "com.sun.xml.ws.config.management.jmx.JMXAgent";
    private static final String DEFAULT_CONFIGURATOR_CLASS_NAME = "com.sun.xml.ws.config.management.server.DefaultConfigurator";
    private static final String DEFAULT_CONFIG_READER_CLASS_NAME = "com.sun.xml.ws.config.management.persistence.JdbcConfigReader";
    private static final String DEFAULT_CONFIG_SAVER_CLASS_NAME = "com.sun.xml.ws.config.management.persistence.JDBCConfigSaver";
    private final ManagedServiceAssertion assertion;

    public ManagementFactory(ManagedServiceAssertion assertion) {
        this.assertion = assertion;
    }

    public <T> Collection<CommunicationServer<T>> createCommunicationImpls(ManagedEndpoint<T> endpoint, EndpointCreationAttributes creationAttributes, ClassLoader classLoader, Configurator<T> configurator, EndpointStarter starter) throws WebServiceException {
        try {
            LinkedList<CommunicationServer<T>> result = new LinkedList<CommunicationServer<T>>();
            Collection<ManagedServiceAssertion.ImplementationRecord> communicationServers = this.assertion.getCommunicationServerImplementations();
            if (communicationServers.isEmpty()) {
                CommunicationServer implementation = ManagementFactory.instantiateImplementation(DEFAULT_COMMUNICATION_SERVER_CLASS_NAME, CommunicationServer.class);
                implementation.init(endpoint, this.assertion, creationAttributes, classLoader, configurator, starter);
                result.add(implementation);
            } else {
                for (ManagedServiceAssertion.ImplementationRecord record : communicationServers) {
                    CommunicationServer implementation = ManagementFactory.instantiateImplementation(record, DEFAULT_COMMUNICATION_SERVER_CLASS_NAME, CommunicationServer.class);
                    implementation.init(endpoint, this.assertion, creationAttributes, classLoader, configurator, starter);
                    result.add(implementation);
                }
            }
            return result;
        }
        catch (ClassCastException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5068_FAILED_COMMUNICATION_SERVER_CAST(), e));
        }
    }

    public <T> Configurator<T> createConfiguratorImpl(ManagedEndpoint<T> endpoint, ConfigReader<T> reader, ConfigSaver<T> saver) throws WebServiceException {
        try {
            ManagedServiceAssertion.ImplementationRecord record = this.assertion.getConfiguratorImplementation();
            Configurator configurator = ManagementFactory.instantiateImplementation(record, DEFAULT_CONFIGURATOR_CLASS_NAME, Configurator.class);
            configurator.init(endpoint, this.assertion, reader, saver);
            return configurator;
        }
        catch (ClassCastException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5071_FAILED_CONFIGURATOR_CAST(), e));
        }
    }

    public <T> ConfigSaver<T> createConfigSaverImpl(ManagedEndpoint<T> endpoint) throws WebServiceException {
        try {
            ManagedServiceAssertion.ImplementationRecord record = this.assertion.getConfigSaverImplementation();
            ConfigSaver configSaver = ManagementFactory.instantiateImplementation(record, DEFAULT_CONFIG_SAVER_CLASS_NAME, ConfigSaver.class);
            configSaver.init(endpoint, this.assertion);
            return configSaver;
        }
        catch (ClassCastException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5070_FAILED_CONFIG_SAVER_CAST(), e));
        }
    }

    public <T> ConfigReader<T> createConfigReaderImpl(ManagedEndpoint<T> endpoint, EndpointCreationAttributes attributes, ClassLoader classLoader, EndpointStarter starter) throws WebServiceException {
        try {
            ManagedServiceAssertion.ImplementationRecord record = this.assertion.getConfigReaderImplementation();
            ConfigReader reader = ManagementFactory.instantiateImplementation(record, DEFAULT_CONFIG_READER_CLASS_NAME, ConfigReader.class);
            reader.init(endpoint, this.assertion, attributes, classLoader, starter);
            return reader;
        }
        catch (ClassCastException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5069_FAILED_CONFIG_READER_CAST(), e));
        }
    }

    private static <T> T instantiateImplementation(ManagedServiceAssertion.ImplementationRecord record, String defaultClassName, Class<T> type) throws WebServiceException {
        String implementation;
        String className = record != null ? ((implementation = record.getImplementation()) != null ? implementation : defaultClassName) : defaultClassName;
        return ManagementFactory.instantiateImplementation(className, type);
    }

    private static <T> T instantiateImplementation(String className, Class<T> type) throws WebServiceException {
        try {
            Class<T> implementation = Class.forName(className).asSubclass(type);
            return implementation.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5015_FAILED_LOAD_CLASS(className), e));
        }
        catch (ClassCastException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5067_FAILED_CLASS_CAST(className, type), e));
        }
        catch (InstantiationException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5016_FAILED_INSTANTIATE_OBJECT(type.getName()), e));
        }
        catch (IllegalAccessException e) {
            throw LOGGER.logSevereException(new WebServiceException(ManagementMessages.WSM_5016_FAILED_INSTANTIATE_OBJECT(type.getName()), e));
        }
    }
}

