/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.MetadataConstants;
import com.sun.xml.ws.mex.client.MetadataUtil;
import com.sun.xml.ws.mex.client.PortInfo;
import com.sun.xml.ws.mex.client.schema.Metadata;
import com.sun.xml.ws.mex.client.schema.MetadataReference;
import com.sun.xml.ws.mex.client.schema.MetadataSection;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataClient {
    private final String[] suffixes = new String[]{"", "/mex"};
    private final MetadataUtil mexUtil = new MetadataUtil();
    private static final JAXBContext jaxbContext;
    private static final Logger logger;

    public Metadata retrieveMetadata(@NotNull String address) {
        for (String suffix : this.suffixes) {
            String newAddress = address.concat(suffix);
            for (Protocol p : Protocol.values()) {
                InputStream responseStream = null;
                try {
                    responseStream = this.mexUtil.getMetadata(newAddress, p);
                    return this.createMetadata(responseStream);
                }
                catch (IOException e) {
                    logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0006_RETRIEVING_MDATA_FAILURE((Object)p, newAddress));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, MessagesMessages.MEX_0008_PARSING_MDATA_FAILURE((Object)p, newAddress));
                }
            }
        }
        logger.log(MetadataConstants.ERROR_LOG_LEVEL, MessagesMessages.MEX_0007_RETURNING_NULL_MDATA());
        return null;
    }

    public Metadata retrieveMetadata(@NotNull MetadataReference reference) {
        List<Object> nodes = reference.getAny();
        for (Object o : nodes) {
            Node node = (Node)o;
            if (!node.getLocalName().equals("Address")) continue;
            String address = node.getFirstChild().getNodeValue();
            return this.retrieveMetadata(address);
        }
        return null;
    }

    public List<PortInfo> getServiceInformation(@NotNull Metadata data) {
        ArrayList<PortInfo> portInfos = new ArrayList<PortInfo>();
        for (MetadataSection section : data.getMetadataSection()) {
            List<PortInfo> newPortInfos;
            Metadata newMetadata;
            if (!section.getDialect().equals("http://schemas.xmlsoap.org/wsdl/")) continue;
            if (section.getAny() != null) {
                this.getServiceInformationFromNode(portInfos, section.getAny());
            }
            if (section.getMetadataReference() != null) {
                newMetadata = this.retrieveMetadata(section.getMetadataReference());
                newPortInfos = this.getServiceInformation(newMetadata);
                portInfos.addAll(newPortInfos);
            }
            if (section.getLocation() == null) continue;
            newMetadata = this.retrieveMetadata(section.getLocation());
            newPortInfos = this.getServiceInformation(newMetadata);
            portInfos.addAll(newPortInfos);
        }
        return portInfos;
    }

    private void getServiceInformationFromNode(List<PortInfo> portInfos, Object node) {
        Node wsdlNode = (Node)node;
        String namespace = this.getAttributeValue(wsdlNode, "targetNamespace");
        NodeList nodes = wsdlNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node serviceNode = nodes.item(i);
            if (serviceNode.getLocalName() == null || !serviceNode.getLocalName().equals("service")) continue;
            Node nameAtt = serviceNode.getAttributes().getNamedItem("name");
            QName serviceName = new QName(namespace, nameAtt.getNodeValue());
            NodeList portNodes = serviceNode.getChildNodes();
            for (int j = 0; j < portNodes.getLength(); ++j) {
                Node portNode = portNodes.item(j);
                if (portNode.getLocalName() == null || !portNode.getLocalName().equals("port")) continue;
                QName portName = new QName(namespace, this.getAttributeValue(portNode, "name"));
                String address = this.getPortAddress(portNode);
                portInfos.add(new PortInfo(serviceName, portName, address));
            }
        }
    }

    private Metadata createMetadata(InputStream stream) throws XMLStreamException, JAXBException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = factory.createXMLStreamReader(stream);
        int state = 0;
        do {
            state = reader.next();
        } while (state != 1 || !reader.getLocalName().equals("Metadata"));
        Unmarshaller uMarhaller = jaxbContext.createUnmarshaller();
        Metadata mData = (Metadata)uMarhaller.unmarshal(reader);
        this.cleanData(mData);
        return mData;
    }

    private String getAttributeValue(Node node, String attName) {
        return node.getAttributes().getNamedItem(attName).getNodeValue();
    }

    private String getPortAddress(Node portNode) {
        NodeList portDetails = portNode.getChildNodes();
        for (int i = 0; i < portDetails.getLength(); ++i) {
            Node addressNode = portDetails.item(i);
            if (addressNode.getLocalName() == null || !addressNode.getLocalName().equals("address")) continue;
            return this.getAttributeValue(addressNode, "location");
        }
        logger.warning(MessagesMessages.MEX_0009_ADDRESS_NOT_FOUND_FOR_PORT(portNode));
        return null;
    }

    private void cleanData(Metadata mData) {
        for (MetadataSection section : mData.getMetadataSection()) {
            if (section.getDialect().equals("http://schemas.xmlsoap.org/wsdl/") && section.getAny() != null) {
                this.cleanWSDLNode((Node)section.getAny());
                continue;
            }
            if (!section.getDialect().equals("http://www.w3.org/2001/XMLSchema") || section.getAny() == null) continue;
            this.cleanSchemaNode((Node)section.getAny());
        }
    }

    private void cleanWSDLNode(Node wsdlNode) {
        NodeList nodes = wsdlNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getLocalName() == null) continue;
            if (node.getLocalName().equals("types")) {
                NodeList schemaNodes = node.getChildNodes();
                for (int j = 0; j < schemaNodes.getLength(); ++j) {
                    Node schemaNode = schemaNodes.item(j);
                    if (schemaNode.getLocalName() == null || !schemaNode.getLocalName().equals("schema")) continue;
                    this.cleanSchemaNode(schemaNode);
                }
                continue;
            }
            if (!node.getLocalName().equals("import")) continue;
            this.cleanImport(node);
        }
    }

    private void cleanSchemaNode(Node schemaNode) {
        NodeList children = schemaNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node importNode = children.item(i);
            if (importNode.getLocalName() == null || !importNode.getLocalName().equals("import")) continue;
            this.cleanImport(importNode);
        }
    }

    private void cleanImport(Node importNode) {
        NamedNodeMap atts = importNode.getAttributes();
        Node location = atts.getNamedItem("schemaLocation");
        if (location != null && location.getNodeValue().equals("")) {
            atts.removeNamedItem("schemaLocation");
            return;
        }
        location = atts.getNamedItem("location");
        if (location != null && location.getNodeValue().equals("")) {
            atts.removeNamedItem("location");
        }
    }

    static {
        logger = Logger.getLogger(MetadataClient.class.getName());
        try {
            jaxbContext = JAXBContext.newInstance("com.sun.xml.ws.mex.client.schema");
        }
        catch (JAXBException jaxbE) {
            throw new AssertionError((Object)jaxbE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Protocol {
        SOAP_1_2,
        SOAP_1_1;

    }
}

