/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.fastinfoset.stax.StAXDocumentSerializer;
import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.CDATA;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class FastInfosetWriter
extends StAXDocumentSerializer
implements XMLWriter {
    PrefixFactory _prefixFactory;

    public FastInfosetWriter(OutputStream os, String encoding) {
        this.setOutputStream(os);
        this.setEncoding(encoding);
    }

    public void reset() {
        super.reset();
        this._prefixFactory = null;
    }

    public void writeStartDocument() {
        try {
            this.writeStartDocument("1.0");
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void writeAttribute(String localName, String value) {
        try {
            super.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void startElement(QName name) {
        this.startElement(name.getLocalPart(), name.getNamespaceURI());
    }

    public void startElement(String localName) {
        this.startElement(localName, "");
    }

    public void startElement(String localName, String uri) {
        try {
            if (uri.length() == 0) {
                this.writeStartElement(localName);
            } else {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                aPrefix = this.getPrefix(uri);
                if (aPrefix == null) {
                    mustDeclarePrefix = true;
                    if (this._prefixFactory != null) {
                        aPrefix = this._prefixFactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this.writeStartElement(aPrefix, localName, uri);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void startElement(String localName, String uri, String prefix) {
        try {
            if (uri.length() == 0) {
                this.writeStartElement(localName);
            } else {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                aPrefix = this.getPrefix(uri);
                if (aPrefix == null) {
                    mustDeclarePrefix = true;
                    aPrefix = prefix;
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this.writeStartElement(aPrefix, localName, uri);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void writeAttribute(String localName, String uri, String value) {
        try {
            if (uri.length() == 0) {
                this.writeAttribute(localName, value);
            } else {
                boolean mustDeclarePrefix = false;
                String prefix = this.getPrefix(uri);
                if (prefix == null) {
                    mustDeclarePrefix = true;
                    if (this._prefixFactory != null) {
                        prefix = this._prefixFactory.getPrefix(uri);
                    }
                    if (prefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this.writeAttribute(prefix, uri, localName, value);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(prefix, uri);
                }
            }
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void startElement(QName name, String prefix) {
        this.startElement(name.getLocalPart(), name.getNamespaceURI(), prefix);
    }

    public void writeAttribute(QName name, String value) {
        this.writeAttribute(name.getLocalPart(), name.getNamespaceURI(), value);
    }

    public void writeAttributeUnquoted(String localName, String value) {
        this.writeAttribute(localName, value);
    }

    public void writeAttributeUnquoted(String localName, String uri, String value) {
        this.writeAttribute(localName, uri, value);
    }

    public void writeAttributeUnquoted(QName name, String value) {
        this.writeAttributeUnquoted(name.getLocalPart(), name.getNamespaceURI(), value);
    }

    public void writeNamespaceDeclaration(String prefix, String uri) {
        try {
            this.setPrefix(prefix, uri);
            this.writeNamespace(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void writeNamespaceDeclaration(String uri) {
        if (this._prefixFactory == null) {
            throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
        }
        String aPrefix = this._prefixFactory.getPrefix(uri);
        this.writeNamespaceDeclaration(aPrefix, uri);
    }

    public void writeChars(String chars) {
        try {
            this.writeCharacters(chars);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void writeChars(CDATA chars) {
        this.writeChars(chars.getText());
    }

    public void writeCharsUnquoted(String chars) {
        this.writeChars(chars);
    }

    public void writeCharsUnquoted(char[] buf, int offset, int len) {
        try {
            this.writeCharacters(buf, offset, len);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void writeComment(String comment) {
        try {
            super.writeComment(comment);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void endElement() {
        try {
            this.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public PrefixFactory getPrefixFactory() {
        return this._prefixFactory;
    }

    public void setPrefixFactory(PrefixFactory factory) {
        this._prefixFactory = factory;
    }

    public String getURI(String prefix) {
        return this.getNamespaceContext().getNamespaceURI(prefix);
    }

    public String getPrefix(String uri) {
        try {
            return super.getPrefix(uri);
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void flush() {
        try {
            super.flush();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public void close() {
        try {
            this.writeEndDocument();
            super.close();
        }
        catch (XMLStreamException e) {
            throw this.wrapException(e);
        }
    }

    public final void writeBytes(byte[] b, int start, int length) {
        try {
            this.encodeTerminationAndCurrentElement(true);
            this.encodeCIIOctetAlgorithmData(1, b, start, length);
        }
        catch (Exception e) {
            this.wrapException(e);
        }
    }

    private XMLWriterException wrapException(Exception e) {
        return new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
    }
}

