/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.AttachmentData;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.incoming.StreamWriterData;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;

public class URIResolver
implements URIDereferencer {
    private SecurityContext securityContext;
    private JAXBFilterProcessingContext pc = null;

    public URIResolver(JAXBFilterProcessingContext pc) {
        this.pc = pc;
        this.securityContext = pc.getSecurityContext();
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Object header;
        HeaderList headers = this.securityContext.getNonSecurityHeaders();
        String tmpId = uRIReference.getURI();
        if (tmpId.startsWith("cid:")) {
            return this.dereferenceAttachments(tmpId.substring(4));
        }
        String id = "";
        int index = tmpId.indexOf("#");
        id = index >= 0 ? tmpId.substring(index + 1) : tmpId;
        if (headers != null && headers.size() > 0) {
            ListIterator listItr = headers.listIterator();
            boolean found = false;
            while (listItr.hasNext()) {
                header = (GenericSecuredHeader)listItr.next();
                if (!((GenericSecuredHeader)header).hasID(id) || ((GenericSecuredHeader)header).hasEncData()) continue;
                return new StreamWriterData((GenericSecuredHeader)header, header.getInscopeNSContext());
            }
        }
        ArrayList pshList = this.securityContext.getProcessedSecurityHeaders();
        for (int j = 0; j < pshList.size(); ++j) {
            header = (SecurityHeaderElement)pshList.get(j);
            if (!id.equals(header.getId())) continue;
            if (header instanceof NamespaceContextInfo) {
                return new StreamWriterData((SecurityHeaderElement)header, ((NamespaceContextInfo)header).getInscopeNSContext());
            }
            throw new URIReferenceException("Cannot derefernce this MessagePart and use if for any crypto operation as the message part is not cached");
        }
        ArrayList bufList = this.securityContext.getBufferedSecurityHeaders();
        for (int j = 0; j < bufList.size(); ++j) {
            SecurityHeaderElement header2 = (SecurityHeaderElement)bufList.get(j);
            if (!id.equals(header2.getId())) continue;
            if (header2 instanceof NamespaceContextInfo) {
                return new StreamWriterData(header2, ((NamespaceContextInfo)((Object)header2)).getInscopeNSContext());
            }
            throw new URIReferenceException("Cannot derefernce this MessagePart and use if for any crypto operation as the message part is not cached");
        }
        Data data = null;
        data = (Data)this.pc.getSTRTransformCache().get(id);
        if (data != null) {
            return data;
        }
        data = (Data)this.pc.getElementCache().get(id);
        return data;
    }

    private Data dereferenceAttachments(String cidRef) throws URIReferenceException {
        AttachmentSet attachments = this.securityContext.getDecryptedAttachmentSet();
        if (attachments == null || attachments.isEmpty()) {
            attachments = this.securityContext.getAttachmentSet();
        }
        if (attachments == null || attachments.isEmpty()) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + cidRef + " was not found");
        }
        Attachment attachment = attachments.get(cidRef);
        if (attachment == null) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + cidRef + " was not found");
        }
        AttachmentData attachData = new AttachmentData(attachment);
        return attachData;
    }
}

