/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public final class WebSocketHolder {
    public volatile WebSocket webSocket;
    public volatile HandShake handshake;
    public volatile WebSocketApplication application;
    public volatile Buffer buffer;
    public volatile ProtocolHandler handler;
    private static final Attribute<WebSocketHolder> webSocketAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("web-socket");

    private WebSocketHolder(ProtocolHandler handler, WebSocket socket) {
        this.handler = handler;
        this.webSocket = socket;
    }

    public static boolean isWebSocketInProgress(Connection connection) {
        return WebSocketHolder.get(connection) != null;
    }

    public static WebSocket getWebSocket(Connection connection) {
        WebSocketHolder holder = WebSocketHolder.get(connection);
        return holder == null ? null : holder.webSocket;
    }

    public static WebSocketHolder get(Connection connection) {
        return webSocketAttribute.get(connection);
    }

    public static WebSocketHolder set(Connection connection, ProtocolHandler handler, WebSocket socket) {
        WebSocketHolder holder = new WebSocketHolder(handler, socket);
        webSocketAttribute.set(connection, holder);
        return holder;
    }
}

