/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.server;

import com.sun.istack.NotNull;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.MessageHeaders;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.message.ProblemActionHeader;
import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.server.WSDLRetriever;
import com.sun.xml.ws.transport.http.servlet.ServletModule;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.SOAPConstants;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.ServiceMode;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceProvider;
import jakarta.xml.ws.soap.Addressing;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@ServiceMode(value=Service.Mode.MESSAGE)
@WebServiceProvider
@Addressing(enabled=true, required=true)
public class MEXEndpoint
implements Provider<Message> {
    @Resource
    protected WebServiceContext wsContext;
    private static final Logger logger = Logger.getLogger(MEXEndpoint.class.getName());

    @Override
    public Message invoke(Message requestMsg) {
        if (requestMsg == null || !requestMsg.hasHeaders()) {
            throw new WebServiceException("Malformed MEX Request");
        }
        WSEndpoint wsEndpoint = (WSEndpoint)this.wsContext.getMessageContext().get("com.sun.xml.ws.api.server.WSEndpoint");
        SOAPVersion soapVersion = wsEndpoint.getBinding().getSOAPVersion();
        MessageHeaders headers = requestMsg.getHeaders();
        String action = AddressingUtils.getAction(headers, AddressingVersion.W3C, soapVersion);
        AddressingVersion wsaVersion = AddressingVersion.W3C;
        if (action == null) {
            action = AddressingUtils.getAction(headers, AddressingVersion.MEMBER, soapVersion);
            wsaVersion = AddressingVersion.MEMBER;
        }
        if (action == null) {
            throw new WebServiceException("No wsa:Action specified");
        }
        if (action.equals("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get")) {
            String toAddress = AddressingUtils.getTo(headers, wsaVersion, soapVersion);
            return this.processGetRequest(requestMsg, toAddress, wsaVersion, soapVersion);
        }
        if (action.equals("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request")) {
            String faultText = MessagesMessages.MEX_0017_GET_METADATA_NOT_IMPLEMENTED("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request", "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get");
            logger.warning(faultText);
            Message faultMessage = this.createFaultMessage(faultText, "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request", wsaVersion, soapVersion);
            this.wsContext.getMessageContext().put("jakarta.xml.ws.soap.http.soapaction.uri", wsaVersion.getDefaultFaultAction());
            return faultMessage;
        }
        throw new UnsupportedOperationException(action);
    }

    private Message processGetRequest(Message request, String address, AddressingVersion wsaVersion, SOAPVersion soapVersion) {
        try {
            WSEndpoint ownerEndpoint = this.findEndpoint();
            if (ownerEndpoint != null) {
                MutableXMLStreamBuffer buffer = new MutableXMLStreamBuffer();
                XMLStreamWriter writer = buffer.createFromXMLStreamWriter();
                address = this.getAddressFromMexAddress(address, soapVersion);
                this.writeStartEnvelope(writer, wsaVersion, soapVersion);
                WSDLRetriever wsdlRetriever = new WSDLRetriever(ownerEndpoint);
                wsdlRetriever.addDocuments(writer, null, address);
                this.writeEndEnvelope(writer);
                writer.flush();
                Message responseMessage = Messages.create(buffer);
                MessageHeaders headers = responseMessage.getHeaders();
                headers.add(Headers.create(new QName(wsaVersion.nsUri, "Action"), "http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse"));
                return responseMessage;
            }
            WebServiceException exception = new WebServiceException(MessagesMessages.MEX_0016_NO_METADATA());
            Message faultMessage = Messages.create(exception, soapVersion);
            this.wsContext.getMessageContext().put("jakarta.xml.ws.soap.http.soapaction.uri", wsaVersion.getDefaultFaultAction());
            return faultMessage;
        }
        catch (XMLStreamException streamE) {
            String exceptionMessage = MessagesMessages.MEX_0001_RESPONSE_WRITING_FAILURE(address);
            logger.log(Level.SEVERE, exceptionMessage, streamE);
            throw new WebServiceException(exceptionMessage, streamE);
        }
    }

    private WSEndpoint findEndpoint() {
        WSEndpoint wsEndpoint = (WSEndpoint)this.wsContext.getMessageContext().get("com.sun.xml.ws.api.server.WSEndpoint");
        HttpServletRequest servletRequest = (HttpServletRequest)this.wsContext.getMessageContext().get("jakarta.xml.ws.servlet.request");
        if (servletRequest == null) {
            throw new WebServiceException("MEX: no ServletRequest can be found");
        }
        WSEndpoint ownerEndpoint = null;
        ServletModule module = wsEndpoint.getContainer().getSPI(ServletModule.class);
        String baseAddress = module.getContextPath(servletRequest);
        String ownerEndpointAddress = null;
        List<BoundEndpoint> boundEndpoints = module.getBoundEndpoints();
        for (BoundEndpoint endpoint : boundEndpoints) {
            if (!endpoint.getEndpoint().equalsProxiedInstance(wsEndpoint)) continue;
            ownerEndpointAddress = endpoint.getAddress(baseAddress).toString();
            break;
        }
        if (ownerEndpointAddress != null) {
            ownerEndpointAddress = this.getAddressFromMexAddress(ownerEndpointAddress, wsEndpoint.getBinding().getSOAPVersion());
            boundEndpoints = module.getBoundEndpoints();
            for (BoundEndpoint endpoint : boundEndpoints) {
                String endpointAddress = endpoint.getAddress(baseAddress).toString();
                if (!endpointAddress.equals(ownerEndpointAddress)) continue;
                ownerEndpoint = endpoint.getEndpoint();
                break;
            }
        }
        return ownerEndpoint;
    }

    private void writeStartEnvelope(XMLStreamWriter writer, AddressingVersion wsaVersion, SOAPVersion soapVersion) throws XMLStreamException {
        String soapPrefix = "soapenv";
        writer.writeStartDocument();
        writer.writeStartElement("soapenv", "Envelope", soapVersion.nsUri);
        writer.writeNamespace("soapenv", soapVersion.nsUri);
        writer.writeNamespace("wsa", wsaVersion.nsUri);
        writer.writeNamespace("mex", "http://schemas.xmlsoap.org/ws/2004/09/mex");
        writer.writeStartElement("soapenv", "Body", soapVersion.nsUri);
        writer.writeStartElement("mex", "Metadata", "http://schemas.xmlsoap.org/ws/2004/09/mex");
    }

    private Message createFaultMessage(@NotNull String faultText, @NotNull String unsupportedAction, @NotNull AddressingVersion av, @NotNull SOAPVersion sv) {
        Message faultMessage;
        QName subcode = av.actionNotSupportedTag;
        try {
            SOAPFault fault;
            if (sv == SOAPVersion.SOAP_12) {
                fault = SOAPVersion.SOAP_12.saajSoapFactory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                Detail detail = fault.addDetail();
                SOAPElement se = detail.addChildElement(av.problemActionTag);
                se = se.addChildElement(av.actionTag);
                se.addTextNode(unsupportedAction);
            } else {
                fault = SOAPVersion.SOAP_11.saajSoapFactory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultText);
            faultMessage = SOAPFaultBuilder.createSOAPFaultMessage(sv, fault);
            if (sv == SOAPVersion.SOAP_11) {
                faultMessage.getHeaders().add(new ProblemActionHeader(unsupportedAction, av));
            }
        }
        catch (SOAPException e) {
            throw new WebServiceException(e);
        }
        return faultMessage;
    }

    private String getAddressFromMexAddress(String mexAddress, SOAPVersion soapVersion) {
        if (mexAddress.endsWith("mex")) {
            return mexAddress.substring(0, mexAddress.length() - "/mex".length());
        }
        if (soapVersion.equals((Object)SOAPVersion.SOAP_11)) {
            return mexAddress.substring(0, mexAddress.length() - "/mex/soap11".length());
        }
        if (soapVersion.equals((Object)SOAPVersion.SOAP_12)) {
            return mexAddress.substring(0, mexAddress.length() - "/mex/soap12".length());
        }
        return null;
    }

    private void writeEndEnvelope(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
    }
}

