/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.runtime.dev.Session;
import com.sun.xml.ws.runtime.dev.SessionManager;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.RmSecurityException;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.faults.CreateSequenceRefusedFault;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.ServerDestinationDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.ServerSourceDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.delivery.PostmanPool;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.rm.runtime.transaction.TransactionPropertySet;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.security.secconv.STRValidationHelper;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import jakarta.xml.ws.EndpointReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;

public class ServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ServerTube.class);
    private static final Level PROTOCOL_FAULT_LOGGING_LEVEL = Level.WARNING;
    static final String SEQUENCE_PROPERTY = "com.sun.xml.ws.sequence";
    static final String MESSAGE_NUMBER_PROPERTY = "com.sun.xml.ws.messagenumber";
    private final RuntimeContext rc;
    private final WSEndpoint endpoint;
    private STRValidationHelper validator;

    public ServerTube(ServerTube original, TubeCloner cloner) {
        super(original, cloner);
        this.rc = original.rc;
        this.endpoint = original.endpoint;
        this.validator = original.validator;
    }

    public ServerTube(RmConfiguration configuration, ServerTubelineAssemblyContext context) {
        super(context.getTubelineHead());
        this.endpoint = context.getEndpoint();
        if (configuration.getAddressingVersion() == null) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1140_NO_ADDRESSING_VERSION_ON_ENDPOINT());
        }
        RuntimeContext.Builder rcBuilder = RuntimeContext.builder(configuration, Communicator.builder("rm-server-tube-communicator").tubelineHead(this.next).addressingVersion(configuration.getAddressingVersion()).soapVersion(configuration.getSoapVersion()).jaxbContext(configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion())).container(context.getEndpoint().getContainer()).build());
        this.rc = rcBuilder.build();
        DeliveryQueueBuilder inboundQueueBuilder = DeliveryQueueBuilder.getBuilder(configuration, PostmanPool.INSTANCE.getPostman(), new ServerDestinationDeliveryCallback(this.rc));
        DeliveryQueueBuilder outboundQueueBuilder = null;
        if (configuration.requestResponseOperationsDetected()) {
            outboundQueueBuilder = DeliveryQueueBuilder.getBuilder(configuration, PostmanPool.INSTANCE.getPostman(), new ServerSourceDeliveryCallback(this.rc));
        }
        SequenceManager sequenceManager = SequenceManagerFactory.INSTANCE.createSequenceManager(configuration.getRmFeature().isPersistenceEnabled(), context.getEndpoint().getServiceName() + "::" + context.getEndpoint().getPortName(), inboundQueueBuilder, outboundQueueBuilder, configuration, context.getEndpoint().getContainer(), null);
        this.rc.setSequenceManager(sequenceManager);
        this.validator = context.getEndpoint().getContainer().getSPI(STRValidationHelper.class);
        if (this.validator == null) {
            this.validator = new MetroSTRValidationHelper();
        }
        LOGGER.fine("STRValidationHelper: " + this.validator.getClass().getName());
    }

    @Override
    public ServerTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            ServerTube serverTube = new ServerTube(this, cloner);
            return serverTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction processRequest(Packet request) {
        LOGGER.entering();
        try {
            NextAction nextAction;
            String wsaAction;
            HaContext.initFrom(request);
            if (HaContext.failoverDetected()) {
                this.rc.sequenceManager().invalidateCache();
            }
            if (this.rc.rmVersion.protocolVersion.isProtocolAction(wsaAction = this.rc.communicator.getWsaAction(request))) {
                NextAction nextAction2 = this.doReturnWith(this.processProtocolMessage(request, wsaAction));
                return nextAction2;
            }
            request.keepTransportBackChannelOpen();
            final JaxwsApplicationMessage message = new JaxwsApplicationMessage(request, request.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
            this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
            this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
            this.validateSecurityContextTokenId(this.rc.sequenceManager().getInboundSequence(message.getSequenceId()).getBoundSecurityTokenReferenceId(), message.getPacket());
            if (!this.hasSession(request)) {
                this.setSession(message.getSequenceId(), request);
            }
            this.exposeSequenceDataToUser(message);
            this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
            boolean txConfigEnabled = this.isTransactionConfigEnabled();
            if (txConfigEnabled) {
                boolean canBegin = this.rc.transactionHandler.canBegin();
                if (canBegin) {
                    int txTimeout = this.rc.configuration.getInternalRmFeature().getUserTransactionTimeout();
                    this.rc.transactionHandler.begin(txTimeout);
                    TransactionPropertySet ps = new TransactionPropertySet();
                    ps.setTransactionOwned(true);
                    message.getPacket().addSatellite(ps);
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(LocalizationMessages.WSRM_5001_COULD_NOT_BEGIN_TRANSACTION());
                }
            }
            boolean persistenceEnabled = this.rc.configuration.getRmFeature().isPersistenceEnabled();
            try {
                this.rc.destinationMessageHandler.registerMessage(message, !persistenceEnabled);
            }
            catch (DuplicateMessageRegistrationException ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(LocalizationMessages.WSRM_1145_DUPLICATE_MSG_NUMBER_RECEIVED(message.getMessageNumber(), message.getSequenceId()), ex);
                }
                nextAction = this.handleDuplicateMessageException(message, request);
                HaContext.clear();
                LOGGER.exiting();
                return nextAction;
            }
            String string = message.getCorrelationId();
            synchronized (string) {
                try {
                    this.rc.suspendedFiberStorage.register(message.getCorrelationId(), Fiber.current());
                    nextAction = this.doSuspend(new Runnable(){

                        @Override
                        public void run() {
                            ((ServerTube)ServerTube.this).rc.destinationMessageHandler.putToDeliveryQueue(message);
                        }
                    });
                    return nextAction;
                }
                catch (Throwable throwable) {
                    NextAction nextAction3;
                    try {
                        throw throwable;
                    }
                    catch (AbstractSoapFaultException ex) {
                        LOGGER.logException(ex, PROTOCOL_FAULT_LOGGING_LEVEL);
                        nextAction3 = this.doReturnWith(ex.toResponse(this.rc, request));
                        return nextAction3;
                    }
                    catch (RxRuntimeException ex) {
                        LOGGER.logSevereException(ex);
                        nextAction3 = this.doThrow(ex);
                        return nextAction3;
                    }
                }
            }
        }
        finally {
            HaContext.clear();
            LOGGER.exiting();
        }
    }

    @Override
    public NextAction processResponse(Packet response) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processResponse(response);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public void preDestroy() {
        LOGGER.entering();
        try {
            this.rc.close();
            SessionManager.removeSessionManager(this.endpoint);
        }
        finally {
            super.preDestroy();
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NextAction handleDuplicateMessageException(final JaxwsApplicationMessage message, Packet request) throws UnknownSequenceException, RxRuntimeException {
        Sequence inboundSequence = this.rc.sequenceManager().getInboundSequence(message.getSequenceId());
        if (inboundSequence.isFailedOver(message.getMessageNumber())) {
            String string = message.getCorrelationId();
            synchronized (string) {
                this.rc.suspendedFiberStorage.register(message.getCorrelationId(), Fiber.current());
                return this.doSuspend(new Runnable(){

                    @Override
                    public void run() {
                        ((ServerTube)ServerTube.this).rc.destinationMessageHandler.putToDeliveryQueue(message);
                    }
                });
            }
        }
        Sequence outboundSequence = this.rc.sequenceManager().getBoundSequence(message.getSequenceId());
        if (outboundSequence != null) {
            Fiber oldRegisteredFiber;
            JaxwsApplicationMessage jaxwsAppMsg;
            final ApplicationMessage _responseMessage = outboundSequence.retrieveMessage(message.getCorrelationId());
            if (_responseMessage == null) {
                return this.doReturnWith(this.rc.protocolHandler.createEmptyAcknowledgementResponse(this.rc.destinationMessageHandler.getAcknowledgementData(message.getSequenceId()), request));
            }
            if ((this.rc.configuration.getRmFeature().isPersistenceEnabled() || HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) && _responseMessage instanceof JaxwsApplicationMessage && (jaxwsAppMsg = (JaxwsApplicationMessage)_responseMessage).getPacket() == null) {
                jaxwsAppMsg.setPacket(this.rc.communicator.createEmptyResponsePacket(request, jaxwsAppMsg.getWsaAction()));
            }
            if ((oldRegisteredFiber = this.rc.suspendedFiberStorage.register(_responseMessage.getCorrelationId(), Fiber.current())) != null) {
                oldRegisteredFiber.resume(this.rc.protocolHandler.createEmptyAcknowledgementResponse(this.rc.destinationMessageHandler.getAcknowledgementData(message.getSequenceId()), request));
            }
            return this.doSuspend(new Runnable(){

                @Override
                public void run() {
                    ((ServerTube)ServerTube.this).rc.sourceMessageHandler.putToDeliveryQueue(_responseMessage);
                }
            });
        }
        return this.doReturnWith(this.rc.protocolHandler.createEmptyAcknowledgementResponse(this.rc.destinationMessageHandler.getAcknowledgementData(message.getSequenceId()), request));
    }

    private Packet processProtocolMessage(Packet request, String wsaAction) throws AbstractSoapFaultException {
        Packet responsePacket = null;
        if (this.rc.rmVersion.protocolVersion.createSequenceAction.equals(wsaAction)) {
            responsePacket = this.handleCreateSequenceAction(request);
        } else if (this.rc.rmVersion.protocolVersion.closeSequenceAction.equals(wsaAction)) {
            responsePacket = this.handleCloseSequenceAction(request);
        } else if (this.rc.rmVersion.protocolVersion.terminateSequenceAction.equals(wsaAction)) {
            responsePacket = this.handleTerminateSequenceAction(request);
        } else if (this.rc.rmVersion.protocolVersion.ackRequestedAction.equals(wsaAction)) {
            responsePacket = this.handleAckRequestedAction(request);
        } else if (this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction.equals(wsaAction)) {
            responsePacket = this.handleSequenceAcknowledgementAction(request);
        } else if (this.rc.rmVersion.protocolVersion.terminateSequenceResponseAction.equals(wsaAction)) {
            responsePacket = this.handleTerminateSequenceResponseAction(request);
        } else {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1134_UNSUPPORTED_PROTOCOL_MESSAGE(wsaAction)));
        }
        responsePacket.setIsProtocolMessage();
        return responsePacket;
    }

    private Packet handleCreateSequenceAction(Packet request) throws CreateSequenceRefusedFault {
        CreateSequenceData requestData = this.rc.protocolHandler.toCreateSequenceData(request);
        EndpointReference requestDestination = null;
        if (requestData.getOfferedSequenceId() != null && this.rc.configuration.requestResponseOperationsDetected()) {
            if (this.rc.sequenceManager().isValid(requestData.getOfferedSequenceId())) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1137_OFFERED_ID_ALREADY_IN_USE(requestData.getOfferedSequenceId()), AbstractSoapFaultException.Code.Sender);
            }
            String wsaTo = this.rc.communicator.getWsaTo(request);
            try {
                requestDestination = new WSEndpointReference(new URI(wsaTo), this.rc.addressingVersion).toSpec();
            }
            catch (URISyntaxException e) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1129_INVALID_VALUE_OF_MESSAGE_HEADER("To", "CreateSequence", wsaTo), AbstractSoapFaultException.Code.Sender, e);
            }
            catch (NullPointerException e) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1130_MISSING_MESSAGE_HEADER("To", "CreateSequence", wsaTo), AbstractSoapFaultException.Code.Sender, e);
            }
        }
        String receivedSctId = null;
        if (requestData.getStrType() != null) {
            String activeSctId = this.validator.getSecurityContextTokenId(request);
            if (activeSctId == null) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1133_NO_SECURITY_TOKEN_IN_REQUEST_PACKET(), AbstractSoapFaultException.Code.Sender);
            }
            try {
                receivedSctId = this.validator.extractSecurityTokenId(requestData.getStrType());
            }
            catch (Exception ex) {
                throw new CreateSequenceRefusedFault(ex.getMessage(), AbstractSoapFaultException.Code.Sender);
            }
            if (!activeSctId.equals(receivedSctId)) {
                throw new CreateSequenceRefusedFault(LocalizationMessages.WSRM_1131_SECURITY_TOKEN_AUTHORIZATION_ERROR(receivedSctId, activeSctId), AbstractSoapFaultException.Code.Sender);
            }
        }
        Sequence inboundSequence = this.rc.sequenceManager().createInboundSequence(this.rc.sequenceManager().generateSequenceUID(), receivedSctId, this.calculateSequenceExpirationTime(requestData.getDuration()));
        CreateSequenceResponseData.Builder responseBuilder = CreateSequenceResponseData.getBuilder(inboundSequence.getId());
        if (requestData.getOfferedSequenceId() != null && this.rc.configuration.requestResponseOperationsDetected()) {
            Sequence outboundSequence = this.rc.sequenceManager().createOutboundSequence(requestData.getOfferedSequenceId(), receivedSctId, this.calculateSequenceExpirationTime(requestData.getOfferedSequenceExpiry()));
            this.rc.sequenceManager().bindSequences(inboundSequence.getId(), outboundSequence.getId());
            this.rc.sequenceManager().bindSequences(outboundSequence.getId(), inboundSequence.getId());
            responseBuilder.acceptedSequenceAcksTo(requestDestination);
        }
        if (!this.hasSession(request)) {
            Utilities.startSession(request.endpoint, inboundSequence.getId());
        }
        return this.rc.protocolHandler.toPacket(responseBuilder.build(), request, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet handleCloseSequenceAction(Packet request) {
        CloseSequenceData requestData = this.rc.protocolHandler.toCloseSequenceData(request);
        this.rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
        Sequence inboundSequence = this.rc.sequenceManager().getInboundSequence(requestData.getSequenceId());
        String boundSequenceId = this.rc.getBoundSequenceId(inboundSequence.getId());
        try {
            this.rc.sequenceManager().closeSequence(inboundSequence.getId());
            CloseSequenceResponseData.Builder responseBuilder = CloseSequenceResponseData.getBuilder(inboundSequence.getId());
            AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder(this.rc.destinationMessageHandler.getAcknowledgementData(inboundSequence.getId()));
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageNumbers(), true);
            inboundSequence.clearAckRequestedFlag();
            responseBuilder.acknowledgementData(ackDataBuilder.build());
            Packet packet = this.rc.protocolHandler.toPacket(responseBuilder.build(), request, false);
            return packet;
        }
        finally {
            if (boundSequenceId != null) {
                this.rc.sequenceManager().closeSequence(boundSequenceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet handleTerminateSequenceAction(Packet request) {
        TerminateSequenceData requestData = this.rc.protocolHandler.toTerminateSequenceData(request);
        this.rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
        Sequence inboundSequence = this.rc.sequenceManager().getInboundSequence(requestData.getSequenceId());
        Sequence outboundSeqence = this.rc.sequenceManager().getBoundSequence(requestData.getSequenceId());
        try {
            TerminateSequenceResponseData.Builder responseBuilder = TerminateSequenceResponseData.getBuilder(inboundSequence.getId());
            responseBuilder.acknowledgementData(this.rc.destinationMessageHandler.getAcknowledgementData(inboundSequence.getId()));
            if (outboundSeqence != null) {
                responseBuilder.boundSequenceData(outboundSeqence.getId(), outboundSeqence.getLastMessageNumber());
            }
            Packet packet = this.rc.protocolHandler.toPacket(responseBuilder.build(), request, false);
            return packet;
        }
        finally {
            Utilities.endSessionIfExists(request.endpoint, inboundSequence.getId());
            try {
                this.rc.sequenceManager().terminateSequence(inboundSequence.getId());
            }
            finally {
                if (outboundSeqence != null) {
                    this.rc.sequenceManager().terminateSequence(outboundSeqence.getId());
                }
            }
        }
    }

    private Packet handleTerminateSequenceResponseAction(Packet request) {
        TerminateSequenceResponseData data = this.rc.protocolHandler.toTerminateSequenceResponseData(request);
        this.rc.destinationMessageHandler.processAcknowledgements(data.getAcknowledgementData());
        request.transportBackChannel.close();
        return this.rc.communicator.createNullResponsePacket(request);
    }

    private Packet handleSequenceAcknowledgementAction(Packet request) {
        AcknowledgementData ackData = this.rc.protocolHandler.getAcknowledgementData(request.getMessage());
        this.rc.destinationMessageHandler.processAcknowledgements(ackData);
        request.transportBackChannel.close();
        return this.rc.communicator.createNullResponsePacket(request);
    }

    private Packet handleAckRequestedAction(Packet request) {
        boolean noStateUpdate = this.rc.configuration.getInternalRmFeature() != null;
        AcknowledgementData ackData = this.rc.protocolHandler.getAcknowledgementData(request.getMessage());
        this.rc.destinationMessageHandler.processAcknowledgements(ackData, noStateUpdate);
        return this.rc.protocolHandler.createEmptyAcknowledgementResponse(this.rc.destinationMessageHandler.getAcknowledgementData(ackData.getAckReqestedSequenceId(), true, noStateUpdate), request);
    }

    private Session getSession(Packet packet) {
        String sessionId = (String)packet.invocationProperties.get("com.sun.xml.ws.sessionid");
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getSessionManager(packet.endpoint, null).getSession(sessionId);
    }

    private boolean hasSession(Packet packet) {
        return this.getSession(packet) != null;
    }

    private void setSession(String sessionId, Packet packet) {
        packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
        Session session = SessionManager.getSessionManager(packet.endpoint, null).getSession(sessionId);
        if (session == null) {
            session = Utilities.startSession(packet.endpoint, sessionId);
        }
        packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
    }

    private void exposeSequenceDataToUser(JaxwsApplicationMessage message) {
        message.getPacket().invocationProperties.put(SEQUENCE_PROPERTY, message.getSequenceId());
        message.getPacket().invocationProperties.put(MESSAGE_NUMBER_PROPERTY, message.getMessageNumber());
    }

    private void validateSecurityContextTokenId(String expectedSctId, Packet packet) throws RmSecurityException {
        boolean isValid;
        String actualSctId = this.validator.getSecurityContextTokenId(packet);
        boolean bl = expectedSctId != null ? expectedSctId.equals(actualSctId) : (isValid = actualSctId == null);
        if (!isValid) {
            throw new RmSecurityException(LocalizationMessages.WSRM_1131_SECURITY_TOKEN_AUTHORIZATION_ERROR(actualSctId, expectedSctId));
        }
    }

    private long calculateSequenceExpirationTime(long expiryDuration) {
        if (expiryDuration == -1L) {
            return -1L;
        }
        return expiryDuration + this.rc.sequenceManager().currentTimeInMillis();
    }

    private boolean isTransactionConfigEnabled() {
        boolean internalRmFeatureExists = this.rc.configuration.getInternalRmFeature() != null;
        ReliableMessagingFeature.DeliveryAssurance deliveryAssurance = this.rc.configuration.getRmFeature().getDeliveryAssurance();
        boolean noDupQoS = deliveryAssurance.equals((Object)ReliableMessagingFeature.DeliveryAssurance.EXACTLY_ONCE) || deliveryAssurance.equals((Object)ReliableMessagingFeature.DeliveryAssurance.AT_MOST_ONCE);
        return internalRmFeatureExists && noDupQoS;
    }

    private class MetroSTRValidationHelper
    implements STRValidationHelper {
        private MetroSTRValidationHelper() {
        }

        @Override
        public String getSecurityContextTokenId(Packet packet) {
            Session session = ServerTube.this.getSession(packet);
            return session != null ? session.getSecurityInfo().getIdentifier() : null;
        }

        @Override
        public String extractSecurityTokenId(SecurityTokenReferenceType str) throws Exception {
            return Utilities.extractSecurityContextTokenId(str);
        }
    }
}

