/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.grizzly;

import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.tcp.grizzly.WSTCPFramedConnectionHandler;
import com.sun.xml.ws.transport.tcp.server.IncomeMessageProcessor;
import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import com.sun.xml.ws.transport.tcp.server.WSTCPConnector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;

public class GrizzlyTCPConnector
implements WSTCPConnector {
    private TCPNIOTransport transport;
    private static final Integer UNIFICATION_PORT = 0;
    private String host;
    private int port;
    private TCPMessageListener listener;
    private final Properties properties;
    private final boolean isPortUnificationMode;

    public GrizzlyTCPConnector(@NotNull String host, int port, @NotNull TCPMessageListener listener) {
        this.host = host;
        this.port = port;
        this.listener = listener;
        this.isPortUnificationMode = false;
        this.properties = new Properties();
    }

    public GrizzlyTCPConnector(@NotNull TCPMessageListener listener, @NotNull Properties properties) {
        this.listener = listener;
        this.isPortUnificationMode = true;
        this.properties = properties;
        this.port = -1;
    }

    @Override
    public void listen() throws IOException {
        if (this.isPortUnificationMode) {
            this.listenOnUnifiedPort();
        } else {
            this.listenOnNewPort();
        }
    }

    private TCPNIOTransport prepareTransport() throws IOException {
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.addFirst(new TransportFilter()).addLast(new WSTCPFramedConnectionHandler());
        if (this.isPortUnificationMode) {
            IncomeMessageProcessor.registerListener(UNIFICATION_PORT, this.listener, this.properties);
        } else {
            IncomeMessageProcessor.registerListener(this.port, this.listener, this.properties);
        }
        this.transport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor(filterChainBuilder.build())).setReadBufferSize(4096)).setKeepAlive(true).setIOStrategy(SameThreadIOStrategy.getInstance())).build();
        this.transport.start();
        return this.transport;
    }

    public void listenOnNewPort() throws IOException {
        this.prepareTransport().bind(this.host, this.port);
    }

    public void listenOnUnifiedPort() throws IOException {
        InetSocketAddress addr = new InetSocketAddress(UNIFICATION_PORT);
        this.prepareTransport().bind(addr);
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.unbindAll();
            IncomeMessageProcessor.releaseListener(this.port);
            this.transport = null;
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public TCPMessageListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(TCPMessageListener listener) {
        this.listener = listener;
    }

    @Override
    public void setFrameSize(int frameSize) {
        this.transport.setReadBufferSize(frameSize);
    }

    @Override
    public int getFrameSize() {
        return this.transport.getReadBufferSize();
    }
}

