/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.grizzly;

import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.server.IncomeMessageProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.NIOConnection;

public final class WSTCPProtocolHandler
extends BaseFilter {
    private static final Logger logger = Logger.getLogger("com.sun.metro.transport.tcp.server");
    private final IncomeMessageProcessor processor;

    public WSTCPProtocolHandler(IncomeMessageProcessor processor) {
        this.processor = processor;
    }

    public String[] getProtocols() {
        return new String[]{"vnd.sun.ws.tcp"};
    }

    public NextAction handle(FilterChainContext ctx) throws IOException {
        if (this.processor != null && ctx.getConnection() instanceof NIOConnection) {
            ByteBuffer messageBuffer = (ByteBuffer)ctx.getMessage();
            messageBuffer.flip();
            this.processor.process(messageBuffer, (SocketChannel)((NIOConnection)ctx.getConnection()).getChannel());
        } else {
            logger.log(Level.WARNING, MessagesMessages.WSTCP_0013_TCP_PROCESSOR_NOT_REGISTERED());
        }
        return null;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        return this.handle(ctx);
    }

    public boolean expireKey(SelectionKey key) {
        if (this.processor != null) {
            this.processor.notifyClosed((SocketChannel)key.channel());
        }
        return true;
    }
}

