/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.SecurityAnnotator;
import com.sun.xml.wss.impl.SecurityRecipient;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.provider.AuthParamHelper;
import com.sun.xml.wss.provider.WssProviderAuthModule;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class ServerSecurityAuthModule
extends WssProviderAuthModule
implements ServerAuthModule {
    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) {
        super.initialize(requestPolicy, responsePolicy, handler, options, false);
    }

    @Override
    public AuthStatus validateRequest(MessageInfo param, Subject subject, Subject serviceSubject) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            this._sEnvironment.setRequesterSubject(subject, context.getExtraneousProperties());
            com.sun.xml.wss.impl.policy.mls.MessagePolicy receiverCnfg = ((DeclarativeSecurityConfiguration)this._policy).receiverSettings();
            context.setSecurityPolicy(receiverCnfg);
            context.setSOAPMessage(AuthParamHelper.getRequest(param));
            context.setSecurityEnvironment(this._sEnvironment);
            SecurityRecipient.validateMessage(context);
            this.populateSharedStateFromContext(param.getMap(), context);
            context.getSecurableSoapMessage().deleteSecurityHeader();
            return AuthStatus.SUCCESS;
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    @Override
    public AuthStatus secureResponse(MessageInfo param, Subject subject) throws AuthException {
        try {
            ProcessingContextImpl context = new ProcessingContextImpl();
            this._sEnvironment.setSubject(subject, context.getExtraneousProperties());
            this.populateContextFromSharedState(context, param.getMap());
            com.sun.xml.wss.impl.policy.mls.MessagePolicy senderCnfg = ((DeclarativeSecurityConfiguration)this._policy).senderSettings();
            SOAPMessage msg = AuthParamHelper.getResponse(param);
            context.setSecurityPolicy(senderCnfg);
            context.setSOAPMessage(msg);
            context.setSecurityEnvironment(this._sEnvironment);
            if (this.optimize != 0 && this.isOptimized(msg)) {
                context.setConfigType(this.optimize);
            } else {
                try {
                    msg.getSOAPBody();
                    msg.getSOAPHeader();
                    context.setConfigType(0);
                }
                catch (SOAPException ex) {
                    throw new AuthException(ex.getMessage());
                }
            }
            SecurityAnnotator.secureMessage(context);
            return AuthStatus.SEND_SUCCESS;
        }
        catch (XWSSecurityException xwsse) {
            xwsse.printStackTrace();
            throw new AuthException(xwsse.getMessage());
        }
    }

    @Override
    public void cleanSubject(MessageInfo msg, Subject subject) throws AuthException {
        if (subject == null) {
            throw new AuthException("Subject is null in cleanSubject");
        }
        if (!subject.isReadOnly()) {
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (ClassCastException | DestroyFailedException dstroyable) {}
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (ClassCastException | DestroyFailedException exception) {}
        }
    }

    private void populateContextFromSharedState(ProcessingContextImpl context, Map sharedState) {
        context.setExtraneousProperty("javax.security.auth.Subject", sharedState.get("REQUESTER_SUBJECT"));
        context.setExtraneousProperty("requester.keyid", sharedState.get("REQUESTER_KEYID"));
        context.setExtraneousProperty("requester.issuername", sharedState.get("REQUESTER_ISSUERNAME"));
        context.setExtraneousProperty("requester.serial", sharedState.get("REQUESTER_SERIAL"));
    }

    private void populateSharedStateFromContext(Map sharedState, ProcessingContextImpl context) {
        sharedState.put("REQUESTER_SUBJECT", context.getExtraneousProperty("javax.security.auth.Subject"));
        sharedState.put("REQUESTER_KEYID", context.getExtraneousProperty("requester.keyid"));
        sharedState.put("REQUESTER_ISSUERNAME", context.getExtraneousProperty("requester.issuername"));
        sharedState.put("REQUESTER_SERIAL", context.getExtraneousProperty("requester.serial"));
    }
}

