/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.AddressingUtils;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.message.RxMessage;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.AckRequestedElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.CreateSequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.CreateSequenceResponseElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.SequenceAcknowledgementElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.SequenceElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.SequenceFaultElement;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.TerminateSequenceElement;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessageBase;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.WsrmProtocolHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.soap.Detail;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.namespace.QName;

final class Wsrm200502ProtocolHandler
extends WsrmProtocolHandler {
    private static final Logger LOGGER = Logger.getLogger(Wsrm200502ProtocolHandler.class);
    private final RuntimeContext rc;

    Wsrm200502ProtocolHandler(RmConfiguration configuration, RuntimeContext rc, Communicator communicator) {
        super(RmRuntimeVersion.WSRM200502, configuration, communicator);
        assert (rc != null);
        this.rc = rc;
    }

    @Override
    public CreateSequenceData toCreateSequenceData(@NotNull Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CreateSequenceElement csElement = (CreateSequenceElement)this.unmarshallMessage(message);
        return csElement.toDataBuilder().build();
    }

    @Override
    public Packet toPacket(CreateSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = this.communicator.createRequestPacket(requestPacket, new CreateSequenceElement(data), this.rmVersion.protocolVersion.createSequenceAction, true);
        return packet;
    }

    @Override
    public CreateSequenceResponseData toCreateSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        CreateSequenceResponseElement csrElement = (CreateSequenceResponseElement)this.unmarshallMessage(message);
        return csrElement.toDataBuilder().build();
    }

    @Override
    public Packet toPacket(CreateSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        return this.communicator.createResponsePacket(requestPacket, new CreateSequenceResponseElement(data), this.rmVersion.protocolVersion.createSequenceResponseAction, clientSideResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseSequenceData toCloseSequenceData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        try {
            ApplicationMessageBase lastAppMessage = new ApplicationMessageBase(""){

                @Override
                public RxMessage.State getState() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            this.loadSequenceHeaderData(lastAppMessage, message);
            this.loadAcknowledgementData(lastAppMessage, message);
            Sequence inboundSequence = this.rc.sequenceManager().getInboundSequence(lastAppMessage.getSequenceId());
            try {
                inboundSequence.registerMessage(lastAppMessage, false);
            }
            catch (Exception ex) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1146_UNEXPECTED_ERROR_WHILE_REGISTERING_MESSAGE(), ex))));
            }
            inboundSequence.acknowledgeMessageNumber(lastAppMessage.getMessageNumber());
            inboundSequence.setAckRequestedFlag();
            CloseSequenceData.Builder dataBuilder = CloseSequenceData.getBuilder(lastAppMessage.getSequenceId(), lastAppMessage.getMessageNumber());
            dataBuilder.acknowledgementData(lastAppMessage.getAcknowledgementData());
            CloseSequenceData closeSequenceData = dataBuilder.build();
            return closeSequenceData;
        }
        finally {
            message.consume();
        }
    }

    @Override
    public Packet toPacket(CloseSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = requestPacket != null ? this.communicator.createEmptyResponsePacket(requestPacket, this.rmVersion.protocolVersion.closeSequenceAction) : this.communicator.createEmptyRequestPacket(this.rmVersion.protocolVersion.closeSequenceAction, false);
        Message message = packet.getMessage();
        ApplicationMessageBase lastAppMessage = new ApplicationMessageBase(""){

            @Override
            public RxMessage.State getState() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        try {
            this.rc.sequenceManager().getOutboundSequence(data.getSequenceId()).registerMessage(lastAppMessage, false);
        }
        catch (DuplicateMessageRegistrationException ex) {
            LOGGER.logSevereException((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            LOGGER.logSevereException((Throwable)ex);
        }
        SequenceElement sequenceElement = new SequenceElement();
        sequenceElement.setId(lastAppMessage.getSequenceId());
        sequenceElement.setMessageNumber(lastAppMessage.getMessageNumber());
        sequenceElement.setLastMessage(new SequenceElement.LastMessage());
        message.getHeaders().add(this.createHeader(sequenceElement));
        this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseSequenceResponseData toCloseSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        try {
            AcknowledgementData ackData = this.getAcknowledgementData(message);
            CloseSequenceResponseData.Builder dataBuilder = CloseSequenceResponseData.getBuilder(ackData.getAcknowledgedSequenceId());
            dataBuilder.acknowledgementData(ackData);
            CloseSequenceResponseData closeSequenceResponseData = dataBuilder.build();
            return closeSequenceResponseData;
        }
        finally {
            message.consume();
        }
    }

    @Override
    public Packet toPacket(CloseSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        Sequence boundSequence = this.rc.sequenceManager().getBoundSequence(data.getSequenceId());
        if (boundSequence != null) {
            CloseSequenceData closeSequenceData = CloseSequenceData.getBuilder(boundSequence.getId(), boundSequence.getLastMessageNumber()).acknowledgementData(data.getAcknowledgementData()).build();
            return this.toPacket(closeSequenceData, requestPacket);
        }
        return this.createEmptyAcknowledgementResponse(data.getAcknowledgementData(), requestPacket);
    }

    @Override
    public TerminateSequenceData toTerminateSequenceData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        TerminateSequenceElement tsElement = (TerminateSequenceElement)this.unmarshallMessage(message);
        TerminateSequenceData.Builder dataBuilder = tsElement.toDataBuilder();
        dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
        return dataBuilder.build();
    }

    @Override
    public Packet toPacket(TerminateSequenceData data, @Nullable Packet requestPacket) throws RxRuntimeException {
        Packet packet = this.communicator.createRequestPacket(requestPacket, new TerminateSequenceElement(data), this.rmVersion.protocolVersion.terminateSequenceAction, true);
        if (data.getAcknowledgementData() != null) {
            this.appendAcknowledgementHeaders(packet, data.getAcknowledgementData());
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateSequenceResponseData toTerminateSequenceResponseData(Packet packet) throws RxRuntimeException {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (!packet.getMessage().isFault());
        Message message = packet.getMessage();
        try {
            TerminateSequenceResponseData.Builder dataBuilder = TerminateSequenceResponseData.getBuilder("");
            dataBuilder.acknowledgementData(this.getAcknowledgementData(message));
            TerminateSequenceResponseData terminateSequenceResponseData = dataBuilder.build();
            return terminateSequenceResponseData;
        }
        finally {
            message.consume();
        }
    }

    @Override
    public Packet toPacket(TerminateSequenceResponseData data, @NotNull Packet requestPacket, boolean clientSideResponse) throws RxRuntimeException {
        if (data.getBoundSequenceId() != null) {
            TerminateSequenceData tsData = TerminateSequenceData.getBuilder(data.getBoundSequenceId(), data.getBoundSequenceLastMessageId()).acknowledgementData(data.getAcknowledgementData()).build();
            Packet packet = this.toPacket(tsData, requestPacket);
            if (!clientSideResponse) {
                packet.getMessage().getHeaders().add(new RelatesToHeader(this.addressingVersion.relatesToTag, AddressingUtils.getMessageID(requestPacket.getMessage().getHeaders(), this.addressingVersion, this.soapVersion)));
            }
            return packet;
        }
        requestPacket.transportBackChannel.close();
        return this.communicator.createNullResponsePacket(requestPacket);
    }

    @Override
    public void appendSequenceHeader(@NotNull Message jaxwsMessage, @NotNull ApplicationMessage message) throws RxRuntimeException {
        assert (message != null);
        assert (message.getSequenceId() != null);
        SequenceElement sequenceHeaderElement = new SequenceElement();
        sequenceHeaderElement.setId(message.getSequenceId());
        sequenceHeaderElement.setMessageNumber(message.getMessageNumber());
        String muTrue = SOAPVersion.SOAP_12.equals((Object)this.soapVersion) ? "true" : "1";
        sequenceHeaderElement.getOtherAttributes().put(this.communicator.soapMustUnderstandAttributeName, muTrue);
        jaxwsMessage.getHeaders().addOrReplace(this.createHeader(sequenceHeaderElement));
    }

    @Override
    public void appendAcknowledgementHeaders(@NotNull Packet packet, @NotNull AcknowledgementData ackData) {
        assert (packet != null);
        assert (packet.getMessage() != null);
        assert (ackData != null);
        Message jaxwsMessage = packet.getMessage();
        if (ackData.getAckReqestedSequenceId() != null) {
            AckRequestedElement ackRequestedElement = new AckRequestedElement();
            ackRequestedElement.setId(ackData.getAckReqestedSequenceId());
            jaxwsMessage.getHeaders().addOrReplace(this.createHeader(ackRequestedElement));
        }
        if (ackData.containsSequenceAcknowledgementData()) {
            SequenceAcknowledgementElement ackElement = new SequenceAcknowledgementElement();
            ackElement.setId(ackData.getAcknowledgedSequenceId());
            for (Sequence.AckRange range : ackData.getAcknowledgedRanges()) {
                ackElement.addAckRange(range.lower, range.upper);
            }
            jaxwsMessage.getHeaders().addOrReplace(this.createHeader(ackElement));
        }
    }

    @Override
    public void loadSequenceHeaderData(@NotNull ApplicationMessage message, @NotNull Message jaxwsMessage) throws RxRuntimeException {
        assert (message != null);
        assert (message.getSequenceId() == null);
        SequenceElement sequenceElement = (SequenceElement)this.readHeaderAsUnderstood(RmRuntimeVersion.WSRM200502.protocolVersion.protocolNamespaceUri, "Sequence", jaxwsMessage);
        if (sequenceElement != null) {
            message.setSequenceData(sequenceElement.getId(), sequenceElement.getMessageNumber());
        }
    }

    @Override
    public void loadAcknowledgementData(@NotNull ApplicationMessage message, @NotNull Message jaxwsMessage) throws RxRuntimeException {
        assert (message != null);
        assert (message.getAcknowledgementData() == null);
        message.setAcknowledgementData(this.getAcknowledgementData(jaxwsMessage));
    }

    @Override
    public AcknowledgementData getAcknowledgementData(Message jaxwsMessage) throws UnknownSequenceException, RxRuntimeException {
        SequenceAcknowledgementElement ackElement;
        assert (jaxwsMessage != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        AckRequestedElement ackRequestedElement = (AckRequestedElement)this.readHeaderAsUnderstood(this.rmVersion.protocolVersion.protocolNamespaceUri, "AckRequested", jaxwsMessage);
        if (ackRequestedElement != null) {
            ackDataBuilder.ackReqestedSequenceId(ackRequestedElement.getId());
        }
        if ((ackElement = (SequenceAcknowledgementElement)this.readHeaderAsUnderstood(this.rmVersion.protocolVersion.protocolNamespaceUri, "SequenceAcknowledgement", jaxwsMessage)) != null) {
            LinkedList<Sequence.AckRange> ranges = new LinkedList<Sequence.AckRange>();
            if (!ackElement.getNack().isEmpty()) {
                ArrayList<BigInteger> nacks = new ArrayList<BigInteger>(ackElement.getNack());
                Collections.sort(nacks);
                long lastLowerBound = 1L;
                for (BigInteger nackId : nacks) {
                    if (lastLowerBound == nackId.longValue()) {
                        ++lastLowerBound;
                        continue;
                    }
                    ranges.add(new Sequence.AckRange(lastLowerBound, nackId.longValue() - 1L));
                    lastLowerBound = nackId.longValue() + 1L;
                }
                long lastMessageId = this.rc.sequenceManager().getSequence(ackElement.getId()).getLastMessageNumber();
                if (lastLowerBound <= lastMessageId) {
                    ranges.add(new Sequence.AckRange(lastLowerBound, lastMessageId));
                }
            } else if (ackElement.getAcknowledgementRange() != null && !ackElement.getAcknowledgementRange().isEmpty()) {
                for (SequenceAcknowledgementElement.AcknowledgementRange rangeElement : ackElement.getAcknowledgementRange()) {
                    ranges.add(new Sequence.AckRange(rangeElement.getLower().longValue(), rangeElement.getUpper().longValue()));
                }
            }
            ackDataBuilder.acknowledgements(ackElement.getId(), ranges, false);
        }
        return ackDataBuilder.build();
    }

    @Override
    public Header createSequenceFaultElementHeader(QName subcode, Detail detail) {
        return Headers.create((JAXBContext)this.rmVersion.getJaxbContext(this.addressingVersion), (Object)new SequenceFaultElement(subcode));
    }

    @Override
    public Packet createEmptyAcknowledgementResponse(AcknowledgementData ackData, Packet requestPacket) throws RxRuntimeException {
        if (ackData.getAckReqestedSequenceId() != null || ackData.containsSequenceAcknowledgementData()) {
            Packet response = this.rc.communicator.createEmptyResponsePacket(requestPacket, this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction);
            response = this.rc.communicator.setEmptyResponseMessage(response, requestPacket, this.rc.rmVersion.protocolVersion.sequenceAcknowledgementAction);
            this.appendAcknowledgementHeaders(response, ackData);
            return response;
        }
        return this.rc.communicator.createNullResponsePacket(requestPacket);
    }
}

