/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.httpspi.servlet;

import com.sun.xml.ws.transport.httpspi.servlet.ExchangeRequestHeaders;
import com.sun.xml.ws.transport.httpspi.servlet.ExchangeResponseHeaders;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.ws.spi.http.HttpContext;
import jakarta.xml.ws.spi.http.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class EndpointHttpExchange
extends HttpExchange {
    private final HttpServletRequest req;
    private final HttpServletResponse res;
    private final ExchangeRequestHeaders reqHeaders;
    private final ExchangeResponseHeaders resHeaders;
    private final ServletContext servletContext;
    private final HttpContext httpContext;
    private static final Set<String> attributes = new HashSet<String>();

    EndpointHttpExchange(HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, HttpContext httpContext) {
        this.req = req;
        this.res = res;
        this.servletContext = servletContext;
        this.httpContext = httpContext;
        this.reqHeaders = new ExchangeRequestHeaders(req);
        this.resHeaders = new ExchangeResponseHeaders(res);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        return this.reqHeaders;
    }

    @Override
    public Map<String, List<String>> getResponseHeaders() {
        return this.resHeaders;
    }

    @Override
    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public String getRequestMethod() {
        return this.req.getMethod();
    }

    @Override
    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getRequestHeader(String name) {
        return this.reqHeaders.getFirst(name);
    }

    @Override
    public void addResponseHeader(String name, String value) {
        this.resHeaders.add(name, value);
    }

    @Override
    public InputStream getRequestBody() throws IOException {
        return this.req.getInputStream();
    }

    @Override
    public OutputStream getResponseBody() throws IOException {
        return this.res.getOutputStream();
    }

    @Override
    public void setStatus(int rCode) {
        this.res.setStatus(rCode);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return InetSocketAddress.createUnresolved(this.req.getServerName(), this.req.getServerPort());
    }

    @Override
    public String getProtocol() {
        return this.req.getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("jakarta.xml.ws.servlet.context")) {
            return this.servletContext;
        }
        if (name.equals("jakarta.xml.ws.servlet.request")) {
            return this.req;
        }
        if (name.equals("jakarta.xml.ws.servlet.response")) {
            return this.res;
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        return attributes;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    @Override
    public String getScheme() {
        return this.req.getScheme();
    }

    @Override
    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    @Override
    public String getQueryString() {
        return this.req.getQueryString();
    }

    static {
        attributes.add("jakarta.xml.ws.servlet.context");
        attributes.add("jakarta.xml.ws.servlet.request");
        attributes.add("jakarta.xml.ws.servlet.response");
    }
}

