/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider.wsit;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfig;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public abstract class ConfigHelper {
    private static final String DEFAULT_HANDLER_CLASS = "com.sun.enterprise.security.jmac.callback.ContainerCallbackHandler";
    private static final String HANDLER_CLASS_PROPERTY = "security.jmac.config.ConfigHelper.CallbackHandler";
    private static final String JMAC_CALLBACK_PROP = "META-INF/services/jakarta.security.auth.message.callback.CallbackHandler";
    private static String handlerClassName = null;
    protected AuthConfigFactory factory = null;
    private ReadWriteLock rwLock;
    private Lock rLock;
    private Lock wLock;
    protected String layer;
    protected String appCtxt;
    protected Map<Object, Object> map;
    protected CallbackHandler cbh;
    protected AuthConfigRegistrationWrapper listenerWrapper = null;

    protected void init(String layer, String appContext, Map<Object, Object> map, CallbackHandler cbh) {
        this.factory = AuthConfigFactory.getFactory();
        this.layer = layer;
        this.appCtxt = appContext;
        this.map = map;
        this.cbh = cbh;
        if (this.cbh == null) {
            this.cbh = this.getCallbackHandler();
        }
        this.rwLock = new ReentrantReadWriteLock(true);
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
        this.listenerWrapper = new AuthConfigRegistrationWrapper(this.layer, this.appCtxt);
    }

    public void setJmacProviderRegisID(String jmacProviderRegisID) {
        this.listenerWrapper.setJmacProviderRegisID(jmacProviderRegisID);
    }

    public AuthConfigRegistrationWrapper getRegistrationWrapper() {
        return this.listenerWrapper;
    }

    public void setRegistrationWrapper(AuthConfigRegistrationWrapper wrapper) {
        this.listenerWrapper = wrapper;
    }

    public AuthConfigRegistrationWrapper.AuthConfigRegistrationListener getRegistrationListener() {
        return this.listenerWrapper.getListener();
    }

    public void disable() {
        this.listenerWrapper.disable();
    }

    public Object getProperty(String key) {
        return this.map == null ? null : this.map.get(key);
    }

    public String getAppContextID() {
        return this.appCtxt;
    }

    public ClientAuthConfig getClientAuthConfig() throws AuthException {
        return (ClientAuthConfig)this.getAuthConfig(false);
    }

    public ServerAuthConfig getServerAuthConfig() throws AuthException {
        return (ServerAuthConfig)this.getAuthConfig(true);
    }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject s) throws AuthException {
        ClientAuthConfig c = (ClientAuthConfig)this.getAuthConfig(false);
        if (c != null) {
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject s) throws AuthException {
        ServerAuthConfig c = (ServerAuthConfig)this.getAuthConfig(true);
        if (c != null) {
            return c.getAuthContext(c.getAuthContextID(info), s, this.map);
        }
        return null;
    }

    protected AuthConfig getAuthConfig(AuthConfigProvider p, boolean isServer) throws AuthException {
        AuthConfig c = null;
        if (p != null) {
            c = isServer ? p.getServerAuthConfig(this.layer, this.appCtxt, this.cbh) : p.getClientAuthConfig(this.layer, this.appCtxt, this.cbh);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthConfig getAuthConfig(boolean isServer) throws AuthException {
        ConfigData d = null;
        AuthConfig c = null;
        boolean disabled = false;
        AuthConfigProvider lastP = null;
        try {
            this.rLock.lock();
            boolean bl = disabled = !this.listenerWrapper.isEnabled();
            if (!disabled && (d = this.listenerWrapper.getConfigData()) != null) {
                c = isServer ? d.sConfig : d.cConfig;
                lastP = d.provider;
            }
        }
        finally {
            this.rLock.unlock();
            if (disabled || c != null || d != null && lastP == null) {
                return c;
            }
        }
        if (d == null) {
            try {
                this.wLock.lock();
                if (this.listenerWrapper.getConfigData() == null) {
                    AuthConfigProvider nextP = this.factory.getConfigProvider(this.layer, this.appCtxt, this.getRegistrationListener());
                    if (nextP != null) {
                        this.listenerWrapper.setConfigData(new ConfigData(nextP, this.getAuthConfig(nextP, isServer)));
                    } else {
                        this.listenerWrapper.setConfigData(new ConfigData());
                    }
                }
                d = this.listenerWrapper.getConfigData();
            }
            finally {
                this.wLock.unlock();
            }
        }
        return isServer ? d.sConfig : d.cConfig;
    }

    protected boolean hasExactMatchAuthProvider() {
        boolean exactMatch = false;
        AuthConfigProvider p = this.factory.getConfigProvider(this.layer, this.appCtxt, null);
        if (p != null) {
            String[] IDs;
            for (String i : IDs = this.factory.getRegistrationIDs(p)) {
                AuthConfigFactory.RegistrationContext c = this.factory.getRegistrationContext(i);
                if (!this.layer.equals(c.getMessageLayer()) || !this.appCtxt.equals(c.getAppContext())) continue;
                exactMatch = true;
                break;
            }
        }
        return exactMatch;
    }

    private CallbackHandler getCallbackHandler() {
        CallbackHandler rvalue = this.getDefaultCallbackHandler();
        return rvalue;
    }

    public static URL loadFromClasspath(String configFileName, ClassLoader cl) {
        if (cl == null) {
            return ClassLoader.getSystemResource(configFileName);
        }
        return cl.getResource(configFileName);
    }

    public CallbackHandler getDefaultCallbackHandler() {
        try {
            final ClassLoader loader = Thread.currentThread().getContextClassLoader();
            CallbackHandler rvalue = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    URL url = ConfigHelper.loadFromClasspath(ConfigHelper.JMAC_CALLBACK_PROP, loader);
                    if (url != null) {
                        InputStream is = null;
                        try {
                            is = url.openStream();
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            int val = is.read();
                            while (val != -1) {
                                os.write(val);
                                val = is.read();
                            }
                            handlerClassName = os.toString();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ConfigHelper.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException ex) {
                                Logger.getLogger(ConfigHelper.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    if (handlerClassName == null) {
                        handlerClassName = System.getProperty(ConfigHelper.HANDLER_CLASS_PROPERTY, ConfigHelper.DEFAULT_HANDLER_CLASS);
                    }
                    String className = handlerClassName;
                    return ConfigHelper.this.loadGFHandler(className, loader);
                }
            });
            return rvalue;
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
    }

    protected CallbackHandler loadGFHandler(String jmacHandler, ClassLoader loader) {
        String classname = jmacHandler;
        Class<?> ret = null;
        try {
            try {
                if (loader != null) {
                    ret = loader.loadClass(classname);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (ret == null) {
                loader = this.getClass().getClassLoader();
                ret = loader.loadClass(classname);
            }
            if (ret != null) {
                CallbackHandler handler = (CallbackHandler)ret.newInstance();
                return handler;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (DEFAULT_HANDLER_CLASS.equals(classname)) {
            return null;
        }
        throw new RuntimeException("Failed to Load CallbackHandler:" + classname);
    }

    public class AuthConfigRegistrationWrapper {
        private String layer;
        private String appCtxt;
        private String jmacProviderRegisID = null;
        private boolean enabled;
        private ConfigData data;
        private Lock wLock;
        private ReadWriteLock rwLock;
        AuthConfigRegistrationListener listener;
        int referenceCount = 1;

        public AuthConfigRegistrationWrapper(String layer, String appCtxt) {
            this.layer = layer;
            this.appCtxt = appCtxt;
            this.rwLock = new ReentrantReadWriteLock(true);
            this.wLock = this.rwLock.writeLock();
            this.enabled = ConfigHelper.this.factory != null;
            this.listener = new AuthConfigRegistrationListener(layer, appCtxt);
        }

        public AuthConfigRegistrationListener getListener() {
            return this.listener;
        }

        public void setListener(AuthConfigRegistrationListener listener) {
            this.listener = listener;
        }

        public void disable() {
            try {
                this.wLock.lock();
                this.setEnabled(false);
            }
            finally {
                this.data = null;
                this.wLock.unlock();
            }
            if (ConfigHelper.this.factory != null) {
                String[] ids = ConfigHelper.this.factory.detachListener(this.listener, this.layer, this.appCtxt);
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        ConfigHelper.this.factory.removeRegistration(ids[i]);
                    }
                }
                if (this.getJmacProviderRegisID() != null) {
                    ConfigHelper.this.factory.removeRegistration(this.getJmacProviderRegisID());
                }
            }
        }

        public void disableWithRefCount() {
            if (this.referenceCount <= 1) {
                this.disable();
            } else {
                try {
                    this.wLock.lock();
                    --this.referenceCount;
                }
                finally {
                    this.wLock.unlock();
                }
            }
        }

        public void incrementReference() {
            try {
                this.wLock.lock();
                ++this.referenceCount;
            }
            finally {
                this.wLock.unlock();
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getJmacProviderRegisID() {
            return this.jmacProviderRegisID;
        }

        public void setJmacProviderRegisID(String jmacProviderRegisID) {
            this.jmacProviderRegisID = jmacProviderRegisID;
        }

        public ConfigData getConfigData() {
            return this.data;
        }

        public void setConfigData(ConfigData data) {
            this.data = data;
        }

        public class AuthConfigRegistrationListener
        implements RegistrationListener {
            private String layer;
            private String appCtxt;

            public AuthConfigRegistrationListener(String layer, String appCtxt) {
                this.layer = layer;
                this.appCtxt = appCtxt;
            }

            @Override
            public void notify(String layer, String appContext) {
                if (this.layer.equals(layer) && (this.appCtxt == null && appContext == null || appContext != null && appContext.equals(this.appCtxt))) {
                    try {
                        AuthConfigRegistrationWrapper.this.wLock.lock();
                        AuthConfigRegistrationWrapper.this.data = null;
                    }
                    finally {
                        AuthConfigRegistrationWrapper.this.wLock.unlock();
                    }
                }
            }
        }
    }

    private class ConfigData {
        private AuthConfigProvider provider;
        private AuthConfig sConfig;
        private AuthConfig cConfig;

        ConfigData() {
            this.provider = null;
            this.sConfig = null;
            this.cConfig = null;
        }

        ConfigData(AuthConfigProvider p, AuthConfig a) {
            this.provider = p;
            if (a == null) {
                this.sConfig = null;
                this.cConfig = null;
            } else if (a instanceof ServerAuthConfig) {
                this.sConfig = a;
                this.cConfig = null;
            } else if (a instanceof ClientAuthConfig) {
                this.sConfig = null;
                this.cConfig = a;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
}

