/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.TokenValidator;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.LogStringsMessages;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class KerberosBinarySecurityToken
implements com.sun.xml.ws.security.opt.api.keyinfo.KerberosBinarySecurityToken,
SecurityHeaderElement,
PolicyBuilder,
TokenValidator,
NamespaceContextInfo,
SecurityElementWriter {
    private String valueType = null;
    private String encodingType = null;
    private String id = "";
    private XMLStreamBuffer mark = null;
    private String namespaceURI = null;
    private String localPart = null;
    private AuthenticationTokenPolicy.KerberosTokenBinding ktPolicy = null;
    private HashMap<String, String> nsDecls;
    private byte[] bstValue = null;
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt", "com.sun.xml.wss.logging.impl.opt.LogStrings");

    public KerberosBinarySecurityToken(XMLStreamReader reader, StreamReaderBufferCreator creator, HashMap nsDecl, XMLInputFactory staxIF) throws XMLStreamException, XMLStreamBufferException {
        this.localPart = reader.getLocalName();
        this.namespaceURI = reader.getNamespaceURI();
        this.id = reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        this.valueType = reader.getAttributeValue(null, "ValueType");
        this.encodingType = reader.getAttributeValue(null, "EncodingType");
        this.mark = new XMLStreamBufferMark(nsDecl, creator);
        creator.createElementFragment(reader, true);
        this.ktPolicy = new AuthenticationTokenPolicy.KerberosTokenBinding();
        this.ktPolicy.setUUID(this.id);
        this.ktPolicy.setValueType(this.valueType);
        this.ktPolicy.setEncodingType(this.encodingType);
        this.nsDecls = nsDecl;
        StreamReaderBufferProcessor bstReader = this.mark.readAsXMLStreamReader();
        bstReader.next();
        this.digestBST(bstReader);
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public byte[] getTokenValue() {
        return this.bstValue;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getLocalPart() {
        return this.localPart;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        return this.mark.readAsXMLStreamReader();
    }

    @Override
    public WSSPolicy getPolicy() {
        return this.ktPolicy;
    }

    @Override
    public void validate(ProcessingContext context) {
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.nsDecls;
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.mark.writeToXMLStreamWriter(streamWriter);
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    private void digestBST(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 1) {
            reader.next();
        }
        if (reader.getEventType() == 4) {
            CharSequence data;
            if (reader instanceof XMLStreamReaderEx && (data = ((XMLStreamReaderEx)reader).getPCDATA()) instanceof Base64Data) {
                Base64Data binaryData = (Base64Data)data;
                this.bstValue = binaryData.getExact();
                return;
            }
            try {
                this.bstValue = Base64.decode(StreamUtil.getCV(reader));
            }
            catch (Base64DecodingException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA((Object)ex));
                throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA((Object)ex));
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA(ex));
                throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1604_ERROR_DECODING_BASE_64_DATA(ex));
            }
        } else {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1603_ERROR_READING_STREAM(null));
            throw new XWSSecurityRuntimeException(LogStringsMessages.WSS_1603_ERROR_READING_STREAM(null));
        }
        if (reader.getEventType() != 2) {
            reader.next();
        }
    }
}

