
package com.sun.xml.ws.rx.localization;

import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.rx.localization.Localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableWSRX_1005_ERROR_CLOSING_IS_AFTER_MSG_DESERIALIZATION() {
        return messageFactory.getMessage("WSRX1005_ERROR_CLOSING_IS_AFTER_MSG_DESERIALIZATION");
    }

    /**
     * WSRX1005: Error closing data input stream after message was de-serialized from bytes"
     * 
     */
    public static String WSRX_1005_ERROR_CLOSING_IS_AFTER_MSG_DESERIALIZATION() {
        return localizer.localize(localizableWSRX_1005_ERROR_CLOSING_IS_AFTER_MSG_DESERIALIZATION());
    }

    public static Localizable localizableWSRX_1002_ERROR_CLOSING_XSW_AFTER_MSG_SERIALIZATION() {
        return messageFactory.getMessage("WSRX1002_ERROR_CLOSING_XSW_AFTER_MSG_SERIALIZATION");
    }

    /**
     * WSRX1002: Error closing XMLStreamWriter after message was serialized to XML stream
     * 
     */
    public static String WSRX_1002_ERROR_CLOSING_XSW_AFTER_MSG_SERIALIZATION() {
        return localizer.localize(localizableWSRX_1002_ERROR_CLOSING_XSW_AFTER_MSG_SERIALIZATION());
    }

    public static Localizable localizableWSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM() {
        return messageFactory.getMessage("WSRX1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM");
    }

    /**
     * WSRX1001: Unable to serialize message to XML stream
     * 
     */
    public static String WSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM() {
        return localizer.localize(localizableWSRX_1001_UNABLE_TO_SERIALIZE_MSG_TO_XML_STREAM());
    }

    public static Localizable localizableWSRX_1003_ERROR_CLOSING_BAOS_AFTER_MSG_SERIALIZATION() {
        return messageFactory.getMessage("WSRX1003_ERROR_CLOSING_BAOS_AFTER_MSG_SERIALIZATION");
    }

    /**
     * WSRX1003: Error closing ByteArrayOutputStream after message was serialized to bytes
     * 
     */
    public static String WSRX_1003_ERROR_CLOSING_BAOS_AFTER_MSG_SERIALIZATION() {
        return localizer.localize(localizableWSRX_1003_ERROR_CLOSING_BAOS_AFTER_MSG_SERIALIZATION());
    }

    public static Localizable localizableWSRX_1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION() {
        return messageFactory.getMessage("WSRX1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION");
    }

    /**
     * "WSRX1004: Error closing XMLStreamReader after message was de-serialized from XML stream"
     * 
     */
    public static String WSRX_1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION() {
        return localizer.localize(localizableWSRX_1004_ERROR_CLOSING_XSR_AFTER_MSG_DESERIALIZATION());
    }

}
