/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.ParseException;
import com.sun.xml.rpc.sp.Parser;
import com.sun.xml.rpc.streaming.Event;
import com.sun.xml.rpc.streaming.Stream;
import com.sun.xml.rpc.streaming.StreamingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class StreamingParser {
    public static final int START = 0;
    public static final int END = 1;
    public static final int ATTR = 2;
    public static final int CHARS = 3;
    public static final int IWS = 4;
    public static final int PI = 5;
    public static final int AT_END = 6;
    private static final int DOC_END = -1;
    private static final int DOC_START = -2;
    private static final int EMPTY = -3;
    private static final int EXCEPTION = -4;
    private Parser parser = null;
    private int currentState = -3;
    private String currentName = null;
    private String currentValue = null;
    private String currentURI = null;
    private int currentLine = -1;

    public StreamingParser(InputStream in) {
        this.parser = new Parser(in, true, true);
    }

    public StreamingParser(File file) throws IOException {
        this.parser = new Parser(file, true, true);
    }

    public Stream getStream() {
        return new Stream(){

            public int next(Event event) {
                int state = StreamingParser.this.next();
                event.state = StreamingParser.this.currentState;
                event.name = StreamingParser.this.currentName;
                event.value = StreamingParser.this.currentValue;
                event.uri = StreamingParser.this.currentURI;
                event.line = StreamingParser.this.currentLine;
                return state;
            }
        };
    }

    public int next() {
        if (this.currentState == 6) {
            return 6;
        }
        try {
            this.currentState = this.parser.parse();
            if (this.currentState == -1) {
                this.currentState = 6;
            }
        }
        catch (ParseException e) {
            throw new StreamingException(e);
        }
        catch (IOException e) {
            throw new StreamingException(e);
        }
        this.currentName = this.parser.getCurName();
        this.currentValue = this.parser.getCurValue();
        this.currentURI = this.parser.getCurURI();
        this.currentLine = this.parser.getLineNumber();
        return this.currentState;
    }

    public int getState() {
        if (this.currentState == -3) {
            throw new IllegalStateException("parser not started");
        }
        if (this.currentState < -4) {
            throw new InternalError();
        }
        return this.currentState;
    }

    public String getName() {
        return this.currentName;
    }

    public String getValue() {
        return this.currentValue;
    }

    public String getURI() {
        return this.currentURI;
    }
}

