/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons.ha;

import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.message.Packet;

public class HaContext {
    private static final ThreadLocal<State> state = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State(null, null);
        }
    };

    public static State initFrom(Packet packet) {
        State old = state.get();
        HaInfo haInfo = null;
        if (packet != null && packet.supports("com.sun.xml.ws.api.message.packet.hainfo")) {
            haInfo = (HaInfo)packet.get("com.sun.xml.ws.api.message.packet.hainfo");
        }
        state.set(new State(packet, haInfo));
        return old;
    }

    public static State initFrom(State newState) {
        State old = state.get();
        state.set(newState);
        return old;
    }

    public static State currentState() {
        return state.get();
    }

    public static void clear() {
        state.get().haInfo = null;
        state.get().packet = null;
    }

    public static HaInfo currentHaInfo() {
        return state.get().haInfo;
    }

    public static void updateHaInfo(HaInfo newValue) {
        state.get().haInfo = newValue;
        if (state.get().packet != null && state.get().packet.supports("com.sun.xml.ws.api.message.packet.hainfo")) {
            state.get().packet.put("com.sun.xml.ws.api.message.packet.hainfo", newValue);
        }
    }

    public static boolean failoverDetected() {
        HaInfo haInfo = state.get().haInfo;
        return haInfo != null && haInfo.isFailOver();
    }

    public static final class State {
        private Packet packet;
        private HaInfo haInfo;

        private State(Packet packet, HaInfo haInfo) {
            this.packet = packet;
            this.haInfo = haInfo;
        }
    }
}

