/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.ha.HaInfo;
import com.sun.xml.ws.api.ha.HighAvailabilityProvider;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.commons.ha.StickyKey;
import com.sun.xml.ws.rx.ha.HighlyAvailableMap;
import com.sun.xml.ws.rx.ha.ReplicationManager;
import com.sun.xml.ws.rx.mc.localization.LocalizationMessages;
import com.sun.xml.ws.rx.mc.runtime.PendingResponseIdentifiers;
import com.sun.xml.ws.rx.message.jaxws.JaxwsMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreFactory;

final class ResponseStorage {
    private static final Logger LOGGER = Logger.getLogger(ResponseStorage.class);
    final HighlyAvailableMap<String, JaxwsMessage> pendingResponses;
    final HighlyAvailableMap<String, PendingResponseIdentifiers> pendingResponseIdentifiers;
    final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

    public ResponseStorage(String uniqueEndpointId) {
        HighlyAvailableMap.StickyReplicationManager responseIdentifiersManager = null;
        PendingMessageReplicationManager responseManager = null;
        if (HighAvailabilityProvider.INSTANCE.isHaEnvironmentConfigured()) {
            BackingStoreFactory bsf = HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY);
            responseIdentifiersManager = new HighlyAvailableMap.StickyReplicationManager(HighAvailabilityProvider.INSTANCE.createBackingStore(bsf, uniqueEndpointId + "_MC_CLIENT_PENDING_MESSAGE_IDENTIFIERS", StickyKey.class, PendingResponseIdentifiers.class));
            responseManager = new PendingMessageReplicationManager(uniqueEndpointId);
        }
        this.pendingResponseIdentifiers = HighlyAvailableMap.create(new HashMap(), responseIdentifiersManager);
        this.pendingResponses = HighlyAvailableMap.create(new HashMap(), responseManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(@NotNull JaxwsMessage response, @NotNull String clientUID) {
        try {
            this.storageLock.writeLock().lock();
            PendingResponseIdentifiers clientResponses = this.pendingResponseIdentifiers.get(clientUID);
            if (clientResponses == null) {
                clientResponses = new PendingResponseIdentifiers();
            }
            this.pendingResponses.put(response.getCorrelationId(), response);
            if (!clientResponses.offer(response.getCorrelationId())) {
                LOGGER.severe(LocalizationMessages.WSMC_0104_ERROR_STORING_RESPONSE(clientUID));
            }
            this.pendingResponseIdentifiers.put(clientUID, clientResponses);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JaxwsMessage getPendingResponse(@NotNull String clientUID) {
        try {
            this.storageLock.readLock().lock();
            PendingResponseIdentifiers clientResponses = this.pendingResponseIdentifiers.get(clientUID);
            if (clientResponses != null && !clientResponses.isEmpty()) {
                String messageId = clientResponses.poll();
                this.pendingResponseIdentifiers.put(clientUID, clientResponses);
                JaxwsMessage jaxwsMessage = this.pendingResponses.remove(messageId);
                return jaxwsMessage;
            }
            JaxwsMessage jaxwsMessage = null;
            return jaxwsMessage;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingResponse(@NotNull String clientUID) {
        try {
            this.storageLock.readLock().lock();
            PendingResponseIdentifiers clientResponses = this.pendingResponseIdentifiers.get(clientUID);
            boolean bl = clientResponses != null && !clientResponses.isEmpty();
            return bl;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
    }

    void invalidateLocalCache() {
        this.pendingResponseIdentifiers.invalidateCache();
        this.pendingResponses.invalidateCache();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PendingMessageReplicationManager
    implements ReplicationManager<String, JaxwsMessage> {
        private BackingStore<StickyKey, JaxwsMessage.JaxwsMessageState> messageStateStore;

        public PendingMessageReplicationManager(String uniqueEndpointId) {
            this.messageStateStore = HighAvailabilityProvider.INSTANCE.createBackingStore(HighAvailabilityProvider.INSTANCE.getBackingStoreFactory(HighAvailabilityProvider.StoreType.IN_MEMORY), uniqueEndpointId + "_MC_PENDING_MESSAGE_STORE", StickyKey.class, JaxwsMessage.JaxwsMessageState.class);
        }

        @Override
        public JaxwsMessage load(String key) {
            JaxwsMessage.JaxwsMessageState state = HighAvailabilityProvider.loadFrom(this.messageStateStore, new StickyKey((Serializable)((Object)key)), null);
            return state.toMessage();
        }

        @Override
        public void save(String key, JaxwsMessage value, boolean isNew) {
            JaxwsMessage.JaxwsMessageState state = value.getState();
            HaInfo haInfo = HaContext.currentHaInfo();
            if (haInfo != null) {
                HighAvailabilityProvider.saveTo(this.messageStateStore, new StickyKey((Serializable)((Object)key), haInfo.getKey()), state, isNew);
            } else {
                StickyKey stickyKey = new StickyKey((Serializable)((Object)key));
                String replicaId = HighAvailabilityProvider.saveTo(this.messageStateStore, stickyKey, state, isNew);
                HaContext.updateHaInfo(new HaInfo(stickyKey.getHashKey(), replicaId, false));
            }
        }

        @Override
        public void remove(String key) {
            HighAvailabilityProvider.removeFrom(this.messageStateStore, new StickyKey((Serializable)((Object)key)));
        }

        @Override
        public void close() {
            HighAvailabilityProvider.close(this.messageStateStore);
        }

        @Override
        public void destroy() {
            HighAvailabilityProvider.destroy(this.messageStateStore);
        }
    }
}

