/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.runtime;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.tx.at.TransactionalFeature;
import com.sun.xml.ws.assembler.dev.ClientTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.ServerTubelineAssemblyContext;
import com.sun.xml.ws.assembler.dev.TubeFactory;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.tx.at.tube.WSATClientTube;
import com.sun.xml.ws.tx.at.tube.WSATServerTube;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

public final class AtTubeFactory
implements TubeFactory {
    private static final String WSAT_SOAP_NSURI = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
    private static final QName AT_ALWAYS_CAPABILITY = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAlwaysCapability");
    private static final QName AT_ASSERTION = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAssertion");

    public Tube createTube(ClientTubelineAssemblyContext context) {
        TransactionalFeature feature = context.getBinding().getFeature(TransactionalFeature.class);
        if (this.isWSATPolicyEnabled(context.getPolicyMap(), context.getWsdlPort(), false) || feature != null && feature.isEnabled()) {
            return new WSATClientTube(context.getTubelineHead(), context, feature);
        }
        return context.getTubelineHead();
    }

    public Tube createTube(ServerTubelineAssemblyContext context) {
        TransactionalFeature feature = context.getEndpoint().getBinding().getFeature(TransactionalFeature.class);
        if (this.isWSATPolicyEnabled(context.getPolicyMap(), context.getWsdlPort(), true) || feature != null && feature.isEnabled()) {
            return new WSATServerTube(context.getTubelineHead(), context, feature);
        }
        return context.getTubelineHead();
    }

    private boolean isWSATPolicyEnabled(PolicyMap policyMap, WSDLPort wsdlPort, boolean isServerSide) {
        if (policyMap == null || wsdlPort == null) {
            return false;
        }
        try {
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
            Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
            for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (policy == null) continue;
                if (isServerSide && policy.contains(AT_ALWAYS_CAPABILITY)) {
                    return true;
                }
                if (!policy.contains(AT_ASSERTION)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            throw new WebServiceException((Throwable)e);
        }
        return false;
    }
}

