/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xwss;

import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.SecurityConfigurationXmlReader;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.xwss.XWSSecurityConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.security.auth.callback.CallbackHandler;

public class SecurityConfiguration
implements XWSSecurityConfiguration {
    private ApplicationSecurityConfiguration configuration = null;
    private CallbackHandler callbackhandler = null;
    private SecurityEnvironment securityEnvironment = null;
    private boolean configEmpty = false;

    public SecurityConfiguration(URL configUrl) throws XWSSecurityException {
        if (configUrl == null) {
            this.configEmpty = true;
            return;
        }
        InputStream config = null;
        try {
            config = configUrl.openStream();
            if (config == null) {
                this.configEmpty = true;
                return;
            }
            this.configuration = SecurityConfigurationXmlReader.createApplicationSecurityConfiguration(config);
            this.callbackhandler = (CallbackHandler)Class.forName(this.configuration.getSecurityEnvironmentHandler(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            this.securityEnvironment = new DefaultSecurityEnvironmentImpl(this.callbackhandler);
        }
        catch (IOException e) {
            throw new XWSSecurityException(e);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        finally {
            try {
                if (config != null) {
                    config.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public SecurityConfiguration(InputStream config) throws XWSSecurityException {
        if (config == null) {
            this.configEmpty = true;
            return;
        }
        try {
            this.configuration = SecurityConfigurationXmlReader.createApplicationSecurityConfiguration(config);
            this.callbackhandler = (CallbackHandler)Class.forName(this.configuration.getSecurityEnvironmentHandler(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            this.securityEnvironment = new DefaultSecurityEnvironmentImpl(this.callbackhandler);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    public ApplicationSecurityConfiguration getSecurityConfiguration() {
        return this.configuration;
    }

    public SecurityEnvironment getSecurityEnvironment() {
        return this.securityEnvironment;
    }

    public boolean isEmpty() {
        return this.configEmpty;
    }
}

