/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.ImageDataContentHandler;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import com.sun.xml.ws.encoding.StringDataContentHandler;
import com.sun.xml.ws.encoding.XmlDataContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

abstract class MimeCodec
implements Codec {
    public static final String MULTIPART_RELATED_MIME_TYPE = "multipart/related";
    private String boundary;
    private String messageContentType;
    private boolean hasAttachments;
    protected Codec rootCodec;
    protected final SOAPVersion version;
    protected final WSBinding binding;

    protected MimeCodec(SOAPVersion version, WSBinding binding) {
        this.version = version;
        this.binding = binding;
    }

    public String getMimeType() {
        return MULTIPART_RELATED_MIME_TYPE;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        Message msg = packet.getMessage();
        if (msg == null) {
            return null;
        }
        if (this.hasAttachments) {
            MimeCodec.writeln("--" + this.boundary, out);
            ContentType ct = this.rootCodec.getStaticContentType(packet);
            String ctStr = ct != null ? ct.getContentType() : this.rootCodec.getMimeType();
            MimeCodec.writeln("Content-Type: " + ctStr, out);
            MimeCodec.writeln(out);
        }
        ContentType primaryCt = this.rootCodec.encode(packet, out);
        if (this.hasAttachments) {
            MimeCodec.writeln(out);
            for (Attachment att : msg.getAttachments()) {
                MimeCodec.writeln("--" + this.boundary, out);
                String cid = att.getContentId();
                if (cid != null && cid.length() > 0 && cid.charAt(0) != '<') {
                    cid = '<' + cid + '>';
                }
                MimeCodec.writeln("Content-Id:" + cid, out);
                MimeCodec.writeln("Content-Type: " + att.getContentType(), out);
                MimeCodec.writeln("Content-Transfer-Encoding: binary", out);
                MimeCodec.writeln(out);
                att.writeTo(out);
                MimeCodec.writeln(out);
            }
            MimeCodec.writeAsAscii("--" + this.boundary, out);
            MimeCodec.writeAsAscii("--", out);
        }
        return this.hasAttachments ? new ContentTypeImpl(this.messageContentType, packet.soapAction, null) : primaryCt;
    }

    public ContentType getStaticContentType(Packet packet) {
        Message msg = packet.getMessage();
        boolean bl = this.hasAttachments = !msg.getAttachments().isEmpty();
        if (this.hasAttachments) {
            this.boundary = "uuid:" + UUID.randomUUID().toString();
            String boundaryParameter = "boundary=\"" + this.boundary + "\"";
            this.messageContentType = "multipart/related; type=\"" + this.rootCodec.getMimeType() + "\"; " + boundaryParameter;
            return new ContentTypeImpl(this.messageContentType, packet.soapAction, null);
        }
        return this.rootCodec.getStaticContentType(packet);
    }

    protected MimeCodec(MimeCodec that) {
        this.version = that.version;
        this.binding = that.binding;
    }

    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        MimeMultipartParser parser = new MimeMultipartParser(in, contentType, this.binding.getFeature(StreamingAttachmentFeature.class));
        this.decode(parser, packet);
    }

    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract void decode(MimeMultipartParser var1, Packet var2) throws IOException;

    public abstract MimeCodec copy();

    public static void writeln(String s, OutputStream out) throws IOException {
        MimeCodec.writeAsAscii(s, out);
        MimeCodec.writeln(out);
    }

    public static void writeAsAscii(String s, OutputStream out) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            out.write((byte)s.charAt(i));
        }
    }

    public static void writeln(OutputStream out) throws IOException {
        out.write(13);
        out.write(10);
    }

    static {
        try {
            CommandMap map = CommandMap.getDefaultCommandMap();
            if (map instanceof MailcapCommandMap) {
                MailcapCommandMap mailMap = (MailcapCommandMap)map;
                String hndlrStr = ";;x-java-content-handler=";
                if (map.createDataContentHandler("text/xml") == null) {
                    mailMap.addMailcap("text/xml" + hndlrStr + XmlDataContentHandler.class.getName());
                }
                if (map.createDataContentHandler("application/xml") == null) {
                    mailMap.addMailcap("application/xml" + hndlrStr + XmlDataContentHandler.class.getName());
                }
                if (map.createDataContentHandler("image/*") == null) {
                    mailMap.addMailcap("image/*" + hndlrStr + ImageDataContentHandler.class.getName());
                }
                if (map.createDataContentHandler("text/plain") == null) {
                    mailMap.addMailcap("text/plain" + hndlrStr + StringDataContentHandler.class.getName());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

