/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.simpletype;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.simpletype.EncoderUtils;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoderBase;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class XSDDateTimeDateEncoder
extends SimpleTypeEncoderBase {
    private static final SimpleTypeEncoder encoder = new XSDDateTimeDateEncoder();
    protected static final Locale locale = new Locale("en_US");
    protected static final SimpleDateFormat timeZoneFormatter = new SimpleDateFormat("HH:mm", locale);
    protected static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", locale);

    protected XSDDateTimeDateEncoder() {
    }

    public static SimpleTypeEncoder getInstance() {
        return encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToString(Object obj, XMLWriter writer) throws Exception {
        if (obj == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(gmtTimeZone);
        calendar.setTime((Date)obj);
        boolean isBC = calendar.get(0) == 0;
        StringBuffer buf = new StringBuffer();
        if (isBC) {
            calendar.set(0, 1);
            buf.append("-");
        }
        SimpleDateFormat simpleDateFormat = dateFormatter;
        synchronized (simpleDateFormat) {
            buf.append(dateFormatter.format(calendar.getTime()));
        }
        return buf.toString();
    }

    public Object stringToObject(String str, XMLReader reader) throws Exception {
        if (str == null) {
            return null;
        }
        return XSDDateTimeDateEncoder.decodeDateUtil(str, null);
    }

    public static void validateDateStr(String dateStr) throws Exception {
        if (dateStr.length() < 19) {
            throw new DeserializationException("xsd.invalid.date", dateStr);
        }
    }

    protected static String getDateFormatPattern(String xsdDateTime) {
        int i;
        String formatPattern = "yyyy";
        int idx = xsdDateTime.indexOf(45, 4);
        for (i = 4; i < idx; ++i) {
            formatPattern = formatPattern + "y";
        }
        formatPattern = formatPattern + "-MM-dd'T'HH:mm:ss";
        for (i = idx = xsdDateTime.indexOf(46); i < xsdDateTime.length() - 1 && i < idx + 3 && Character.isDigit(xsdDateTime.charAt(i + 1)); ++i) {
            if (i == idx) {
                formatPattern = formatPattern + ".";
            }
            formatPattern = formatPattern + "S";
        }
        return formatPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Date decodeDateUtil(String str, StringBuffer zone) throws Exception {
        if (str == null) {
            return null;
        }
        str = EncoderUtils.collapseWhitespace(str);
        Calendar cal = Calendar.getInstance();
        boolean isNeg = false;
        if ((str = EncoderUtils.collapseWhitespace(str)).charAt(0) == '+') {
            str = str.substring(1);
        }
        if (str.charAt(0) == '-') {
            str = str.substring(1);
            isNeg = true;
        }
        XSDDateTimeDateEncoder.validateDateStr(str);
        StringBuffer strBuf = new StringBuffer(30);
        int dateLen = XSDDateTimeDateEncoder.getDateFormatPattern(str, strBuf);
        String pattern = strBuf.toString();
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(gmtTimeZone);
        String tmp = str.substring(0, dateLen);
        Date date = df.parse(str.substring(0, dateLen));
        if (dateLen < str.length()) {
            int start = dateLen;
            if (Character.isDigit(str.charAt(start))) {
                int end;
                for (end = start; end < str.length() && Character.isDigit(str.charAt(end)); ++end) {
                }
                String tmp2 = str.substring(start, start + 1);
                int fractmilli = Integer.parseInt(str.substring(start, start + 1));
                if (fractmilli >= 5) {
                    date.setTime(date.getTime() + 1L);
                }
                start = end;
            }
            if (start < str.length()) {
                if (str.charAt(start) != 'Z') {
                    Date tzOffset;
                    if (zone != null) {
                        zone.append(str.substring(start));
                    }
                    tmp = str.substring(start + 1);
                    SimpleDateFormat simpleDateFormat = timeZoneFormatter;
                    synchronized (simpleDateFormat) {
                        tzOffset = timeZoneFormatter.parse(str.substring(start + 1));
                    }
                    long millis = str.charAt(start) == '+' ? -tzOffset.getTime() : tzOffset.getTime();
                    date.setTime(date.getTime() + millis);
                } else if (str.charAt(start) == 'Z') {
                    cal.setTimeZone(gmtTimeZone);
                }
            }
        }
        if (isNeg) {
            cal.setTime(date);
            cal.set(0, 0);
            date = cal.getTime();
        }
        return date;
    }

    protected static int getDateFormatPattern(String dateStr, StringBuffer strBuf) {
        int i;
        String formatPattern = "yyyy";
        strBuf.append(formatPattern);
        int idx = dateStr.indexOf(45, 4);
        for (i = 4; i < idx; ++i) {
            strBuf.append('y');
        }
        strBuf.append("-MM-dd'T'HH:mm:ss");
        for (i = idx = dateStr.indexOf(46); idx > 0 && i < dateStr.length() - 1 && i < idx + 3 && Character.isDigit(dateStr.charAt(i + 1)); ++i) {
            if (i == idx) {
                strBuf.append('.');
            }
            strBuf.append('S');
        }
        return strBuf.length() - 2;
    }

    static {
        dateFormatter.setTimeZone(gmtTimeZone);
        timeZoneFormatter.setTimeZone(gmtTimeZone);
    }
}

