/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SignedData;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SignedMessagePart
implements SecurityElement,
SignedData,
SecurityElementWriter {
    protected boolean isCanonicalized = false;
    private SecurityElement se = null;
    private SOAPBody body = null;
    private boolean contentOnly = false;
    private List attributeValuePrefixes = null;
    private ByteArrayOutputStream storedStream = new ByteArrayOutputStream();
    protected byte[] digestValue = null;

    public SignedMessagePart() {
    }

    public SignedMessagePart(SecurityElement se) {
        this.se = se;
    }

    public SignedMessagePart(SOAPBody body, boolean contentOnly) {
        this.body = body;
        this.contentOnly = contentOnly;
    }

    public String getId() {
        if (this.body != null) {
            if (!this.contentOnly) {
                return this.body.getId();
            }
            return this.body.getBodyContentId();
        }
        return this.se.getId();
    }

    public void setId(String id) {
        if (this.body != null) {
            if (!this.contentOnly) {
                this.body.setId(id);
            } else {
                this.body.setBodyContentId(id);
            }
        } else {
            this.se.setId(id);
        }
    }

    public String getNamespaceURI() {
        if (this.body != null) {
            if (!this.contentOnly) {
                return this.body.getSOAPVersion().nsUri;
            }
            return this.body.getPayloadNamespaceURI();
        }
        return this.se.getNamespaceURI();
    }

    public String getLocalPart() {
        if (this.body != null) {
            if (!this.contentOnly) {
                return "Body";
            }
            return this.body.getPayloadLocalPart();
        }
        return this.se.getLocalPart();
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream os) {
        try {
            if (this.isCanonicalized) {
                this.writeCanonicalized(os);
            }
        }
        catch (IOException ioe) {
            throw new XWSSecurityRuntimeException(ioe);
        }
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (this.body != null) {
            this.body.cachePayLoad();
            this.attributeValuePrefixes = this.body.getAttributeValuePrefixes();
            if (!this.contentOnly) {
                this.body.writeTo(streamWriter);
            } else {
                this.body.writePayload(streamWriter);
            }
        } else {
            ((SecurityElementWriter)((Object)this.se)).writeTo(streamWriter);
        }
    }

    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        this.writeTo(streamWriter);
    }

    public void writeCanonicalized(OutputStream os) throws IOException {
        if (this.storedStream == null) {
            return;
        }
        this.storedStream.writeTo(os);
    }

    public void setDigestValue(byte[] digestValue) {
        this.digestValue = digestValue;
    }

    public byte[] getDigestValue() {
        return this.digestValue;
    }

    public List getAttributeValuePrefixes() {
        return this.attributeValuePrefixes;
    }
}

