/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.dsig;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.AttachmentData;
import com.sun.xml.ws.security.opt.impl.crypto.JAXBDataImpl;
import com.sun.xml.ws.security.opt.impl.crypto.SSBData;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.ws.security.opt.impl.message.SecuredMessage;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.ws.security.opt.impl.util.JAXBUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.stream.XMLStreamException;

public class DSigResolver
implements URIDereferencer {
    private static DSigResolver resolver = new DSigResolver();
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");

    public static URIDereferencer getInstance() {
        return resolver;
    }

    public Data dereference(URIReference uriRef, XMLCryptoContext context) throws URIReferenceException {
        String uri = null;
        uri = uriRef.getURI();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1750_URI_TOBE_DEREFERENCED(uri));
        }
        return this.dereferenceURI(uri, context);
    }

    private Data dereferenceURI(String url, XMLCryptoContext context) throws URIReferenceException {
        try {
            AuthenticationTokenPolicy.SAMLAssertionBinding resolvedSAMLBinding;
            String uri = url;
            if (uri.startsWith("#SAML") && (resolvedSAMLBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)context.getProperty("SAML_CLIENT_CACHE")) != null) {
                String id;
                uri = id = resolvedSAMLBinding.getAssertionId();
            }
            if (uri == null || uri.equals("")) {
                logger.log(Level.FINEST, "Empty Reference URI not supported");
                throw new UnsupportedOperationException("Empty Reference URI not supported");
            }
            if (uri.charAt(0) == '#') {
                return this.dereferenceFragment(DSigResolver.getIdFromFragmentRef(uri), context);
            }
            if (uri.startsWith("cid:") || uri.startsWith("attachmentRef:")) {
                return this.dereferenceAttachments(uri, context);
            }
            if (uri.startsWith("http")) {
                throw new UnsupportedOperationException("Not supported in optimized path");
            }
            return this.dereferenceFragment(uri, context);
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }

    Data dereferenceAttachments(String uri, XMLCryptoContext context) throws URIReferenceException {
        JAXBFilterProcessingContext filterContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        SecuredMessage secureMsg = filterContext.getSecuredMessage();
        Attachment attachment = secureMsg.getAttachment(uri);
        if (attachment == null) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + uri + " was not found");
        }
        AttachmentData attachData = new AttachmentData(attachment);
        return attachData;
    }

    Data dereferenceFragment(String uri, XMLCryptoContext context) throws XWSSecurityException {
        JAXBFilterProcessingContext filterContext = (JAXBFilterProcessingContext)context.get("http://wss.sun.com#processingContext");
        HashMap elementCache = filterContext.getElementCache();
        try {
            Object obj;
            if (elementCache.size() > 0 && (obj = elementCache.get(uri)) != null && obj instanceof Header) {
                Header reqdHeader = (Header)obj;
                JAXBContext jaxbContext = JAXBUtil.getJAXBContext();
                JAXBElement jb = (JAXBElement)reqdHeader.readAsJAXB(jaxbContext.createUnmarshaller());
                JAXBDataImpl jData = new JAXBDataImpl(jb, jaxbContext, filterContext.getNamespaceContext());
                return jData;
            }
            return this.getDataById(filterContext, uri);
        }
        catch (JAXBException jbe) {
            throw new XWSSecurityException(jbe);
        }
        catch (XMLStreamException sxe) {
            throw new XWSSecurityException(sxe);
        }
    }

    private static String getIdFromFragmentRef(String ref) {
        char start = ref.charAt(0);
        if (start == '#') {
            return ref.substring(1);
        }
        return ref;
    }

    private Data getDataById(JAXBFilterProcessingContext context, String uri) throws JAXBException, XMLStreamException, XWSSecurityException {
        SecurityHeader secHeader;
        SecurityHeaderElement she;
        SecuredMessage secMessage = context.getSecuredMessage();
        ArrayList headerList = secMessage.getHeaders();
        SecurityHeaderElement reqdHeader = null;
        for (int i = 0; i < headerList.size(); ++i) {
            SecurityHeaderElement she2;
            Object header = headerList.get(i);
            if (!(header instanceof SecurityHeaderElement) || !uri.equals((she2 = (SecurityHeaderElement)header).getId())) continue;
            reqdHeader = she2;
            break;
        }
        if (!(reqdHeader != null || (she = (secHeader = context.getSecurityHeader()).getChildElement(uri)) == null || "SecurityTokenReference".equals(she.getLocalPart()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(she.getNamespaceURI()))) {
            reqdHeader = she;
        }
        if (reqdHeader != null) {
            return new JAXBDataImpl(reqdHeader, context.getNamespaceContext(), false);
        }
        try {
            Object body = secMessage.getBody();
            if (body instanceof SecurityElement) {
                SecurityElement se = (SecurityElement)body;
                if (uri.equals(se.getId())) {
                    return new JAXBDataImpl(se, context.getNamespaceContext(), false);
                }
            } else if (body instanceof SOAPBody) {
                SOAPBody soapBody = (SOAPBody)body;
                if (uri.equals(soapBody.getId())) {
                    return new SSBData(soapBody, false, context.getNamespaceContext());
                }
                if (uri.equals(soapBody.getBodyContentId())) {
                    return new SSBData(soapBody, true, context.getNamespaceContext());
                }
            }
        }
        catch (XWSSecurityException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1704_ERROR_RESOLVING_ID(uri), ex);
            throw new XWSSecurityException(ex);
        }
        Data data = null;
        data = (Data)context.getSTRTransformCache().get(uri);
        if (data != null) {
            return data;
        }
        data = (Data)context.getElementCache().get(uri);
        return data;
    }
}

