/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.org.apache.xml.internal.security.Init;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurityHeaderException;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.dsig.NamespaceContextImpl;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.logging.LogStringsMessages;
import com.sun.xml.wss.util.NodeListImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SecurableSoapMessage
extends SOAPMessage {
    private NamespaceContext nsContext;
    Random rnd = new Random();
    static XPathFactory xpathFactory = null;
    private SOAPMessage soapMessage;
    private boolean optimized = false;
    private SOAPElement wsseSecurity;
    private boolean doNotSetMU = false;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public SecurableSoapMessage() {
    }

    public SecurableSoapMessage(SOAPMessage soapMessage) throws XWSSecurityException {
        this.init(soapMessage);
    }

    public void init(SOAPMessage soapMessage) throws XWSSecurityException {
        this.soapMessage = soapMessage;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, LogStringsMessages.WSS_0100_CREATE_FOR_CREATING_IMPL(((Object)((Object)this)).getClass().getName()));
        }
    }

    public SOAPEnvelope getEnvelope() throws XWSSecurityException {
        SOAPEnvelope envelope = null;
        try {
            envelope = this.getSOAPPart().getEnvelope();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0399_SOAP_ENVELOPE_EXCEPTION(), e);
            throw new XWSSecurityException(e);
        }
        return envelope;
    }

    private SOAPHeader findSoapHeader(boolean doCreate) throws XWSSecurityException {
        try {
            SOAPHeader header = this.getSOAPPart().getEnvelope().getHeader();
            if (header != null) {
                return header;
            }
            if (doCreate) {
                return this.getSOAPPart().getEnvelope().addHeader();
            }
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0369_SOAP_EXCEPTION(e.getMessage()));
            throw new XWSSecurityException(e);
        }
        return null;
    }

    public SecurityHeader findWsseSecurityHeaderBlock(boolean doCreate, boolean mustUnderstand) throws XWSSecurityException {
        SOAPHeader header;
        if (this.wsseSecurity != null) {
            if (this.wsseSecurity.getParentNode() == null) {
                this.wsseSecurity = null;
            } else {
                return (SecurityHeader)this.wsseSecurity;
            }
        }
        if (null == (header = this.findSoapHeader(doCreate))) {
            return null;
        }
        NodeList headerChildNodes = header.getChildNodes();
        if (headerChildNodes != null) {
            Node currentNode = null;
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                currentNode = headerChildNodes.item(i);
                if (!"Security".equals(currentNode.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentNode.getNamespaceURI())) continue;
                this.wsseSecurity = (SOAPElement)currentNode;
                break;
            }
        }
        if (this.wsseSecurity == null && !doCreate) {
            return null;
        }
        if (this.wsseSecurity == null && doCreate) {
            this.wsseSecurity = (SOAPElement)this.getSOAPPart().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            this.wsseSecurity.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (mustUnderstand && !this.doNotSetMU) {
                this.wsseSecurity.setAttributeNS(this.getEnvelope().getNamespaceURI(), this.getEnvelope().getPrefix() + ":mustUnderstand", "1");
            }
            XMLUtil.prependChildElement((Element)header, (Element)this.wsseSecurity, (Document)this.getSOAPPart());
        }
        if (this.wsseSecurity == null) {
            throw new XWSSecurityException("Internal Error: wsse:Security Header found null");
        }
        this.wsseSecurity = new SecurityHeader(this.wsseSecurity);
        return (SecurityHeader)this.wsseSecurity;
    }

    public SecurityHeader findSecurityHeader() throws XWSSecurityException {
        return this.findWsseSecurityHeaderBlock(false, false);
    }

    public SecurityHeader findOrCreateSecurityHeader() throws XWSSecurityException {
        return this.findWsseSecurityHeaderBlock(true, true);
    }

    public void deleteSecurityHeader() {
        try {
            this.findSecurityHeader();
            if (null != this.wsseSecurity) {
                this.wsseSecurity.detachNode();
                this.wsseSecurity = null;
            }
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0370_ERROR_DELETING_SECHEADER(), e.getMessage());
        }
    }

    public void resetMustUnderstandOnSecHeader() {
        try {
            this.findSecurityHeader();
            if (null != this.wsseSecurity) {
                this.wsseSecurity.removeAttributeNS(this.getEnvelope().getNamespaceURI(), "mustUnderstand");
            }
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0370_ERROR_DELETING_SECHEADER(), e.getMessage());
        }
    }

    public void generateSecurityHeaderException(String exceptionMessage) throws SecurityHeaderException, XWSSecurityException {
        SecurityHeaderException she = new SecurityHeaderException(exceptionMessage);
        this.generateFault(SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Error while processing Security Header", she));
        log.log(Level.SEVERE, LogStringsMessages.WSS_0370_ERROR_PROCESSING_SECHEADER(), she);
        throw she;
    }

    public static WssSoapFaultException newSOAPFaultException(String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(null, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public void generateFault(WssSoapFaultException sfe) throws XWSSecurityException {
        try {
            SOAPBody body = this.soapMessage.getSOAPBody();
            body.removeContents();
            QName faultCode = sfe.getFaultCode();
            Name faultCodeName = null;
            faultCodeName = faultCode == null ? SOAPFactory.newInstance().createName("Client", null, "http://schemas.xmlsoap.org/soap/envelope/") : SOAPFactory.newInstance().createName(faultCode.getLocalPart(), faultCode.getPrefix(), faultCode.getNamespaceURI());
            body.addFault(faultCodeName, sfe.getFaultString());
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0371_ERROR_GENERATE_FAULT(e.getMessage()));
            throw new XWSSecurityException(e);
        }
    }

    public SOAPPart getSOAPPart() {
        return this.soapMessage.getSOAPPart();
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        try {
            return this.soapMessage.getSOAPBody();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0398_SOAP_BODY_EXCEPTION(), e);
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public void setSOAPMessage(SOAPMessage soapMsg) throws XWSSecurityException {
        this.init(soapMsg);
    }

    public void addAttachmentPart(AttachmentPart AttachmentPart2) {
        this.soapMessage.addAttachmentPart(AttachmentPart2);
    }

    public int countAttachments() {
        return this.soapMessage.countAttachments();
    }

    public AttachmentPart createAttachmentPart() {
        return this.soapMessage.createAttachmentPart();
    }

    public AttachmentPart createAttachmentPart(Object content, String contentType) {
        return this.soapMessage.createAttachmentPart(content, contentType);
    }

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) {
        return this.soapMessage.createAttachmentPart(dataHandler);
    }

    public boolean equals(Object obj) {
        return this.soapMessage.equals(obj);
    }

    public Iterator getAttachments() {
        return this.soapMessage.getAttachments();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return this.soapMessage.getAttachments(headers);
    }

    public String getContentDescription() {
        return this.soapMessage.getContentDescription();
    }

    public MimeHeaders getMimeHeaders() {
        return this.soapMessage.getMimeHeaders();
    }

    public Object getProperty(String property) throws SOAPException {
        return this.soapMessage.getProperty(property);
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.soapMessage.getSOAPHeader();
    }

    public int hashCode() {
        return this.soapMessage.hashCode();
    }

    public void removeAllAttachments() {
        this.soapMessage.removeAllAttachments();
    }

    public boolean saveRequired() {
        return this.soapMessage.saveRequired();
    }

    public void setContentDescription(String description) {
        this.soapMessage.setContentDescription(description);
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this.soapMessage.setProperty(property, value);
    }

    public String toString() {
        return this.soapMessage.toString();
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        this.soapMessage.writeTo(out);
    }

    public void saveChanges() throws SOAPException {
        this.soapMessage.saveChanges();
    }

    public NamespaceContext getNamespaceContext() throws XWSSecurityException {
        if (this.nsContext == null) {
            this.nsContext = new NamespaceContextImpl();
            ((NamespaceContextImpl)this.nsContext).add(this.getEnvelope().getPrefix(), this.getEnvelope().getNamespaceURI());
            if (this.getEnvelope().getNamespaceURI() == "http://www.w3.org/2003/05/soap-envelope") {
                ((NamespaceContextImpl)this.nsContext).add("SOAP-ENV", "http://www.w3.org/2003/05/soap-envelope");
                ((NamespaceContextImpl)this.nsContext).add("env", "http://www.w3.org/2003/05/soap-envelope");
            }
        }
        return this.nsContext;
    }

    public String generateId() throws XWSSecurityException {
        int intRandom = this.rnd.nextInt();
        String id = "XWSSGID-" + String.valueOf(System.currentTimeMillis()) + String.valueOf(intRandom);
        return id;
    }

    public void generateWsuId(Element element) throws XWSSecurityException {
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.generateId());
    }

    public void generateWsuId(Element element, String id) throws XWSSecurityException {
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    private boolean wsuIdIsUnique(NodeList wsuIdElements, String id) {
        boolean result = true;
        if (wsuIdElements == null) {
            return result;
        }
        for (int i = 0; i < wsuIdElements.getLength(); ++i) {
            if (!((Element)wsuIdElements.item(i)).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id").equals(id)) continue;
            result = false;
        }
        return result;
    }

    public SOAPElement getElementByWsuId(String id) throws XWSSecurityException {
        Element element = this.getSOAPPart().getElementById(id);
        if (element != null) {
            return (SOAPElement)element;
        }
        SOAPElement result = null;
        String xpath = "//*[@wsu:Id='" + id + "']";
        try {
            XPath xPATH = xpathFactory.newXPath();
            xPATH.setNamespaceContext(this.getNamespaceContext());
            XPathExpression xpathExpr = xPATH.compile(xpath);
            NodeList elements = (NodeList)xpathExpr.evaluate(this.getSOAPPart(), XPathConstants.NODESET);
            if (elements != null) {
                result = (SOAPElement)elements.item(0);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0374_ERROR_APACHE_XPATH_API(id, e.getMessage()), new Object[]{id, e.getMessage()});
            throw new XWSSecurityException(e);
        }
        return result;
    }

    public Element getElementById(String id) throws XWSSecurityException {
        Element element;
        if (id.startsWith("#")) {
            id = id.substring(1);
        }
        if ((element = this.getSOAPPart().getElementById(id)) != null) {
            return element;
        }
        Object result = null;
        result = this.getElementByWsuId(id);
        if (result == null) {
            SOAPPart soapPart = this.getSOAPPart();
            NodeList assertions = soapPart.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
            if (assertions.getLength() <= 0 || assertions.item(0) == null) {
                assertions = soapPart.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            }
            String assertionId = null;
            int len = assertions.getLength();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    SOAPElement elem = (SOAPElement)assertions.item(i);
                    assertionId = elem.getAttributeNode("ID") != null ? elem.getAttribute("ID") : elem.getAttribute("AssertionID");
                    if (!id.equals(assertionId)) continue;
                    result = elem;
                    break;
                }
            }
        }
        if (result == null) {
            NodeList elems;
            String xpath = "//*[@Id='" + id + "']";
            try {
                XPath xPATH = xpathFactory.newXPath();
                xPATH.setNamespaceContext(this.getNamespaceContext());
                XPathExpression xpathExpr = xPATH.compile(xpath);
                elems = (NodeList)xpathExpr.evaluate(this.getSOAPPart(), XPathConstants.NODESET);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0375_ERROR_APACHE_XPATH_API(id, e.getMessage()), new Object[]{id, e.getMessage()});
                throw new XWSSecurityException(e);
            }
            if (elems == null || elems.getLength() == 0) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0285_ERROR_NO_ELEMENT());
                throw new XWSSecurityException("No elements exist with Id/WsuId: " + id);
            }
            for (int i = 0; i < elems.getLength(); ++i) {
                Element elem = (Element)elems.item(i);
                String namespace = elem.getNamespaceURI();
                if (!namespace.equals("http://www.w3.org/2000/09/xmldsig#") && !namespace.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                result = elem;
                break;
            }
            if (elems.getLength() > 1) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0286_INVALID_NOOF_ELEMENTS());
                throw new XWSSecurityException("More than one element exists with Id/WsuId: " + id);
            }
        }
        return result;
    }

    public AttachmentPart getAttachmentPart(String uri) throws XWSSecurityException {
        AttachmentPart _part;
        block8: {
            _part = null;
            String uri_tmp = uri;
            try {
                if (uri.startsWith("cid:")) {
                    uri = "<" + uri.substring("cid:".length()) + ">";
                    MimeHeaders headersToMatch = new MimeHeaders();
                    headersToMatch.addHeader("Content-ID", uri);
                    Iterator i = this.getAttachments(headersToMatch);
                    AttachmentPart attachmentPart = _part = i == null ? null : (AttachmentPart)i.next();
                    if (_part == null) {
                        uri = uri_tmp;
                        uri = uri.substring("cid:".length());
                        headersToMatch = new MimeHeaders();
                        headersToMatch.addHeader("Content-ID", uri);
                        i = this.getAttachments(headersToMatch);
                        AttachmentPart attachmentPart2 = _part = i == null ? null : (AttachmentPart)i.next();
                    }
                    if (_part == null) {
                        throw new XWSSecurityException("Unable to Locate AttachmentPart for uri " + uri);
                    }
                    break block8;
                }
                if (uri.startsWith("attachmentRef:")) {
                    Iterator j = this.getAttachments();
                    while (j.hasNext()) {
                        int eqIndex;
                        AttachmentPart p = (AttachmentPart)j.next();
                        String cl = p.getContentId();
                        if (cl == null || (eqIndex = cl.indexOf("=")) <= -1 || !(cl = cl.substring(1, eqIndex)).equalsIgnoreCase(uri.substring("attachmentRef:".length()))) continue;
                        _part = p;
                        break block8;
                    }
                    break block8;
                }
                String clocation = this.convertAbsolute2Relative(uri);
                MimeHeaders headersToMatch = new MimeHeaders();
                headersToMatch.addHeader("Content-Location", clocation);
                Iterator i = this.getAttachments(headersToMatch);
                AttachmentPart attachmentPart = _part = i == null ? null : (AttachmentPart)i.next();
                if (_part == null) {
                    clocation = uri;
                    headersToMatch.removeAllHeaders();
                    headersToMatch.addHeader("Content-Location", clocation);
                    i = this.getAttachments(headersToMatch);
                    _part = i == null ? null : (AttachmentPart)i.next();
                }
            }
            catch (Exception se) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0287_ERROR_EXTRACTING_ATTACHMENTPART(), se);
                throw new XWSSecurityException(se);
            }
        }
        return _part;
    }

    private String convertAbsolute2Relative(String clocation) {
        MimeHeader mh;
        Iterator clocs;
        MimeHeaders mimeHeaders = this.getMimeHeaders();
        String enclsgClocation = null;
        if (mimeHeaders != null && (clocs = mimeHeaders.getMatchingHeaders(new String[]{"Content-Location"})) != null && (mh = (MimeHeader)clocs.next()) != null) {
            enclsgClocation = mh.getValue();
        }
        if (enclsgClocation != null && clocation.startsWith(enclsgClocation)) {
            clocation = clocation.substring(enclsgClocation.length());
        } else if (clocation.startsWith("thismessage:/")) {
            clocation = clocation.substring("thismessage:/".length());
        }
        return clocation;
    }

    public static String getIdFromFragmentRef(String ref) {
        char start = ref.charAt(0);
        if (start == '#') {
            return ref.substring(1);
        }
        return ref;
    }

    public Object getMessageParts(Target target) throws XWSSecurityException {
        Object retValue = null;
        String type = target.getType();
        String value = target.getValue();
        boolean throwFault = false;
        boolean headersOnly = target.isSOAPHeadersOnly();
        if (type.equals("qname")) {
            try {
                if (value == "{http://schemas.xmlsoap.org/soap/envelope/}Body") {
                    SOAPBody se = this.getSOAPBody();
                    retValue = new NodeList((SOAPElement)se){
                        Node node;
                        final /* synthetic */ SOAPElement val$se;
                        {
                            this.val$se = sOAPElement;
                            this.node = this.val$se;
                        }

                        public int getLength() {
                            return 1;
                        }

                        public Node item(int num) {
                            if (num == 0) {
                                return this.node;
                            }
                            return null;
                        }
                    };
                } else {
                    QName name = QName.valueOf(value);
                    if (!headersOnly) {
                        retValue = "".equals(name.getNamespaceURI()) ? this.getSOAPPart().getElementsByTagNameNS("*", name.getLocalPart()) : this.getSOAPPart().getElementsByTagNameNS(name.getNamespaceURI(), name.getLocalPart());
                    } else {
                        retValue = new NodeListImpl();
                        NodeList hdrChilds = this.getSOAPHeader().getChildNodes();
                        for (int i = 0; i < hdrChilds.getLength(); ++i) {
                            Node child = hdrChilds.item(i);
                            if (child.getNodeType() != 1) continue;
                            if ("".equals(name.getNamespaceURI())) {
                                if (!name.getLocalPart().equals(child.getLocalName())) continue;
                                ((NodeListImpl)retValue).add(child);
                                continue;
                            }
                            if (name.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || name.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) {
                                if (!child.getNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !child.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) continue;
                                if (!"".equals(name.getLocalPart())) {
                                    if (!name.getLocalPart().equals(child.getLocalName())) continue;
                                    ((NodeListImpl)retValue).add(child);
                                    continue;
                                }
                                ((NodeListImpl)retValue).add(child);
                                continue;
                            }
                            if (!"".equals(name.getLocalPart())) {
                                if (!name.getNamespaceURI().equals(child.getNamespaceURI()) || !name.getLocalPart().equals(child.getLocalName())) continue;
                                ((NodeListImpl)retValue).add(child);
                                continue;
                            }
                            if (!name.getNamespaceURI().equals(child.getNamespaceURI())) continue;
                            ((NodeListImpl)retValue).add(child);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0288_FAILED_GET_MESSAGE_PARTS_QNAME(), e);
                throw new XWSSecurityRuntimeException(e);
            }
            if (retValue == null || ((NodeList)retValue).getLength() == 0) {
                throwFault = true;
            }
        } else if (type.equals("xpath")) {
            try {
                XPathFactory xpathFactory = XPathFactory.newInstance();
                XPath xpath = xpathFactory.newXPath();
                xpath.setNamespaceContext(this.getNamespaceContext());
                XPathExpression xpathExpr = xpath.compile(value);
                retValue = (NodeList)xpathExpr.evaluate(this.getSOAPPart(), XPathConstants.NODESET);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0289_FAILED_GET_MESSAGE_PARTS_X_PATH(), e);
                throw new XWSSecurityRuntimeException(e);
            }
            if (retValue == null || ((NodeList)retValue).getLength() == 0) {
                throwFault = true;
            }
        } else if (type.equals("uri")) {
            try {
                retValue = this.getElementById(value);
            }
            catch (XWSSecurityException xwse) {
                try {
                    retValue = this.getAttachmentPart(value);
                    if (retValue == null) {
                        throwFault = true;
                    }
                }
                catch (Exception se) {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0290_FAILED_GET_MESSAGE_PARTS_URI(), se);
                    throw new XWSSecurityException("No message part can be identified by the Target: " + value);
                }
            }
        }
        if (throwFault) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "No message part can be identified by the Target:" + value);
            }
            return null;
        }
        return retValue;
    }

    public AttachmentPart getAttachment(SOAPElement element) throws SOAPException {
        log.log(Level.SEVERE, LogStringsMessages.WSS_0291_UNSUPPORTED_OPERATION_GET_ATTACHMENT());
        throw new UnsupportedOperationException("Operation Not Supported");
    }

    public void removeAttachments(MimeHeaders hdrs) {
        log.log(Level.SEVERE, LogStringsMessages.WSS_0292_UNSUPPORTED_OPERATION_REMOVE_ATTACHMENT());
        throw new UnsupportedOperationException("Operation Not Supported");
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void setOptimized(boolean optimized) {
        this.optimized = optimized;
    }

    public void setDoNotSetMU(boolean doNotSetMU) {
        this.doNotSetMU = doNotSetMU;
    }

    static {
        Init.init();
        xpathFactory = XPathFactory.newInstance();
    }
}

