/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricKeyBinding
extends KeyBindingBase {
    String _keyAlgorithm = MessageConstants._EMPTY;
    String _keyIdentifier = MessageConstants._EMPTY;
    String _certAlias = MessageConstants._EMPTY;
    boolean _useReceivedSecret = false;
    SecretKey _secretKey = null;
    private boolean isEKSHA1 = false;

    public SymmetricKeyBinding() {
        this.setPolicyIdentifier("SymmetricKeyBinding");
    }

    public SymmetricKeyBinding(String keyIdentifier, String keyAlgorithm) {
        this();
        this._keyIdentifier = keyIdentifier;
        this._keyAlgorithm = keyAlgorithm;
    }

    public void setKeyIdentifier(String keyIdentifier) {
        this._keyIdentifier = keyIdentifier;
    }

    public String getKeyIdentifier() {
        return this._keyIdentifier;
    }

    public void setCertAlias(String certAlias) {
        this._certAlias = certAlias;
    }

    public String getCertAlias() {
        return this._certAlias;
    }

    public void setUseReceivedSecret(boolean useReceivedSecret) {
        this._useReceivedSecret = useReceivedSecret;
    }

    public boolean getUseReceivedSecret() {
        return this._useReceivedSecret;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this._keyAlgorithm = keyAlgorithm;
    }

    public String getKeyAlgorithm() {
        return this._keyAlgorithm;
    }

    public void setSecretKey(SecretKey secretKey) {
        this._secretKey = secretKey;
    }

    public SecretKey getSecretKey() {
        return this._secretKey;
    }

    public MLSPolicy newX509CertificateKeyBinding() {
        if (this.isReadOnly()) {
            throw new RuntimeException("Can not create X509CertificateKeyBinding : Policy is Readonly");
        }
        this._keyBinding = new AuthenticationTokenPolicy.X509CertificateBinding();
        return this._keyBinding;
    }

    public boolean usesEKSHA1KeyBinding() {
        return this.isEKSHA1;
    }

    public void usesEKSHA1KeyBinding(boolean value) {
        this.isEKSHA1 = value;
    }

    public boolean equals(WSSPolicy policy) {
        boolean assrt = false;
        try {
            boolean b3;
            SymmetricKeyBinding skBinding = (SymmetricKeyBinding)policy;
            boolean b1 = this._keyIdentifier.equals("") ? true : this._keyIdentifier.equals(skBinding.getKeyIdentifier());
            boolean b2 = this._keyAlgorithm.equals("") ? true : this._keyAlgorithm.equals(skBinding.getKeyAlgorithm());
            boolean bl = b3 = this._certAlias.equals("") ? true : this._certAlias.equals(skBinding.getCertAlias());
            boolean b4 = !this._useReceivedSecret ? true : this._useReceivedSecret == skBinding.getUseReceivedSecret();
            boolean b5 = this._keyBinding.equals(policy._keyBinding);
            boolean b6 = this.isEKSHA1 == skBinding.usesEKSHA1KeyBinding();
            assrt = b1 && b2 && b3 && b4 && b5 && b6;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return assrt;
    }

    public boolean equalsIgnoreTargets(WSSPolicy binding) {
        return this.equals(binding);
    }

    public Object clone() {
        SymmetricKeyBinding skBinding = new SymmetricKeyBinding();
        try {
            skBinding.setUUID(this.getUUID());
            skBinding.setKeyIdentifier(this._keyIdentifier);
            skBinding.setKeyAlgorithm(this._keyAlgorithm);
            skBinding.setCertAlias(this._certAlias);
            skBinding.setUseReceivedSecret(this._useReceivedSecret);
            skBinding.usesEKSHA1KeyBinding(this.isEKSHA1);
            SecretKeySpec ky0 = (SecretKeySpec)this._secretKey;
            if (ky0 != null) {
                SecretKeySpec key = new SecretKeySpec(ky0.getEncoded(), ky0.getAlgorithm());
                skBinding.setSecretKey(key);
            }
            if (this._keyBinding != null) {
                if (this._keyBinding instanceof AuthenticationTokenPolicy.UsernameTokenBinding) {
                    skBinding.setKeyBinding((AuthenticationTokenPolicy.UsernameTokenBinding)((AuthenticationTokenPolicy.UsernameTokenBinding)this._keyBinding).clone());
                } else if (this._keyBinding instanceof AuthenticationTokenPolicy.X509CertificateBinding) {
                    skBinding.setKeyBinding((AuthenticationTokenPolicy.X509CertificateBinding)((AuthenticationTokenPolicy.X509CertificateBinding)this._keyBinding).clone());
                } else if (this._keyBinding instanceof AuthenticationTokenPolicy.KerberosTokenBinding) {
                    skBinding.setKeyBinding((AuthenticationTokenPolicy.KerberosTokenBinding)((AuthenticationTokenPolicy.KerberosTokenBinding)this._keyBinding).clone());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return skBinding;
    }

    public String getType() {
        return "SymmetricKeyBinding";
    }

    public String toString() {
        return "SymmetricKeyBinding::" + this.getKeyAlgorithm() + "::" + this._keyIdentifier;
    }
}

