/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.transform;

import com.sun.xml.wss.impl.c14n.Canonicalizer;
import com.sun.xml.wss.impl.c14n.CanonicalizerFactory;
import com.sun.xml.wss.impl.dsig.AttachmentData;
import com.sun.xml.wss.logging.impl.dsig.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.soap.AttachmentPart;

public class ACOTransform
extends TransformService {
    private static Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.dsig", "com.sun.xml.wss.logging.impl.dsig.LogStrings");
    private static final String implementedTransformURI = "http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-swa-profile-1.0#Attachment-Content-Only-Transform";

    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
    }

    private Data canonicalize(OctetStreamData data) {
        throw new UnsupportedOperationException();
    }

    private Data canonicalize(AttachmentData data, OutputStream outputStream) throws TransformException {
        try {
            AttachmentPart attachment = data.getAttachmentPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            attachment.getDataHandler().writeTo((OutputStream)os);
            OutputStream byteStream = null;
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(os.toByteArray());
            byteStream = outputStream == null ? new ByteArrayOutputStream() : outputStream;
            Canonicalizer canonicalizer = CanonicalizerFactory.getCanonicalizer(attachment.getContentType());
            InputStream is = canonicalizer.canonicalize(byteInputStream, byteStream);
            if (is != null) {
                return new OctetStreamData(is);
            }
            return null;
        }
        catch (TransformException te) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1318_AC_TRANSFORM_ERROR(), te);
            throw te;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1318_AC_TRANSFORM_ERROR(), ex);
            throw new TransformException(ex.getMessage());
        }
    }

    public boolean isFeatureSupported(String str) {
        return false;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        if (data instanceof OctetStreamData) {
            return this.canonicalize((OctetStreamData)data);
        }
        if (data instanceof AttachmentData) {
            OutputStream os = null;
            return this.canonicalize((AttachmentData)data, os);
        }
        return null;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if (data instanceof AttachmentData) {
            return this.canonicalize((AttachmentData)data, outputStream);
        }
        return null;
    }
}

