//Copyright Sun Microsystems Inc. 2004 - 2005.

package javax.annotation.security;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * Specifies that all security roles are allowed to invoke the specified 
 * method(s) i.e that the specified method(s) are "unchecked". It can be 
 * specified on a class or on methods. Specifying it on the class means that 
 * it applies to all methods of the class. If specified at the method level, 
 * it only affects that method. If the RolesAllowed is specified at the class 
 * level and this annotation is applied at the method level, the PermitAll 
 * annotation overrides the RolesAllowed for the specified method.
 *
 * @see javax.annotation.security.RolesAllowed
 * @see javax.annotation.security.DenyAll
 *
 * @since Common Annotations 1.0
 */
@Documented
@Retention (RUNTIME)
@Target({TYPE, METHOD})
public @interface PermitAll {
}
