/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;

public class BusinessQueryTest {
    String httpProxyHost = "";
    String httpProxyPort = "";
    String regUrli = "";
    String regUrlp = "";
    Properties connProps = new Properties();
    private static final String QUERY_URL = "query.url";
    private static final String PUBLISH_URL = "publish.url";
    private static final String PROXY_HOST = "http.proxy.host";
    private static final String PROXY_PORT = "http.proxy.port";

    public static void main(String[] stringArray) {
        String string2 = "%USA%";
        try {
            Properties properties = new Properties();
            properties.load(BusinessQueryTest.class.getResourceAsStream("query.properties"));
            BusinessQueryTest businessQueryTest = new BusinessQueryTest();
            businessQueryTest.executeQueryTest(properties, string2);
        }
        catch (JAXRException jAXRException) {
            System.err.println("Error during the test: " + jAXRException);
        }
        catch (IOException iOException) {
            System.err.println("Can not open properties file");
        }
    }

    public void executeQueryTest(Properties properties, String string2) throws JAXRException {
        try {
            this.assignUserProperties(properties);
            this.setConnectionProperties();
            ConnectionFactory connectionFactory = ConnectionFactory.newInstance();
            connectionFactory.setProperties(this.connProps);
            Connection connection = connectionFactory.createConnection();
            RegistryService registryService = connection.getRegistryService();
            BusinessQueryManager businessQueryManager = registryService.getBusinessQueryManager();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("sortByNameDesc");
            BulkResponse bulkResponse = businessQueryManager.findOrganizations(arrayList2, arrayList, null, null, null, null);
            if (bulkResponse.getStatus() == 0) {
                System.out.println("Successfully queried the registry for organization matching the name pattern: \"" + string2 + "\"");
                Collection collection = bulkResponse.getCollection();
                System.out.println("Results found: " + collection.size() + "\n");
                for (Organization organization : collection) {
                    System.out.println("Organization Name: " + this.getName(organization));
                    System.out.println("Organization Key: " + organization.getKey().getId());
                    System.out.println("Organization Description: " + this.getDescription(organization));
                    Collection collection2 = organization.getServices();
                    for (Service service : collection2) {
                        System.out.println("\tService Name: " + this.getName(service));
                        System.out.println("\tService Key: " + service.getKey().getId());
                        System.out.println("\tService Description: " + this.getDescription(service));
                    }
                }
            } else {
                System.err.println("One or more JAXRExceptions occurred during the query operation:");
                Collection collection = bulkResponse.getExceptions();
                for (Exception exception : collection) {
                    System.err.println(exception.toString());
                }
            }
        }
        catch (JAXRException jAXRException) {
            jAXRException.printStackTrace();
        }
    }

    private void assignUserProperties(Properties properties) {
        String string2 = ((String)properties.get(QUERY_URL)).trim();
        if (string2 != null) {
            this.regUrli = string2;
        }
        if ((string2 = ((String)properties.get(PUBLISH_URL)).trim()) != null) {
            this.regUrlp = string2;
        }
        if ((string2 = ((String)properties.get(PROXY_HOST)).trim()) != null) {
            this.httpProxyHost = string2;
        }
        if ((string2 = ((String)properties.get(PROXY_PORT)).trim()) != null) {
            this.httpProxyPort = string2;
        }
    }

    private void setConnectionProperties() {
        this.connProps.setProperty("javax.xml.registry.queryManagerURL", this.regUrli);
        this.connProps.setProperty("javax.xml.registry.lifeCycleManagerURL", this.regUrlp);
        this.connProps.setProperty("javax.xml.registry.factoryClass", "com.sun.xml.registry.uddi.ConnectionFactoryImpl");
        this.connProps.setProperty("com.sun.xml.registry.http.proxyHost", this.httpProxyHost);
        this.connProps.setProperty("com.sun.xml.registry.http.proxyPort", this.httpProxyPort);
    }

    private String getName(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getName().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    private String getDescription(RegistryObject registryObject) throws JAXRException {
        try {
            return registryObject.getDescription().getValue();
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }
}

