/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.wsdl.WSDLOperationFinder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

final class SOAPActionBasedOperationFinder
extends WSDLOperationFinder {
    private final Map<String, QName> methodHandlers = new HashMap<String, QName>();

    public SOAPActionBasedOperationFinder(WSDLPort wsdlModel, WSBinding binding, @Nullable SEIModel seiModel) {
        super(wsdlModel, binding, seiModel);
        HashMap<String, Integer> unique = new HashMap<String, Integer>();
        if (seiModel != null) {
            String soapAction;
            for (JavaMethodImpl javaMethodImpl : ((AbstractSEIModelImpl)seiModel).getJavaMethods()) {
                soapAction = javaMethodImpl.getOperation().getSOAPAction();
                Integer count = (Integer)unique.get(soapAction);
                if (count == null) {
                    unique.put(soapAction, 1);
                    continue;
                }
                count = count + 1;
                unique.put(soapAction, count);
            }
            for (JavaMethodImpl javaMethodImpl : ((AbstractSEIModelImpl)seiModel).getJavaMethods()) {
                soapAction = javaMethodImpl.getOperation().getSOAPAction();
                if ((Integer)unique.get(soapAction) != 1) continue;
                this.methodHandlers.put('\"' + soapAction + '\"', javaMethodImpl.getOperation().getName());
            }
        } else {
            for (WSDLBoundOperation wSDLBoundOperation : wsdlModel.getBinding().getBindingOperations()) {
                this.methodHandlers.put(wSDLBoundOperation.getSOAPAction(), wSDLBoundOperation.getName());
            }
        }
    }

    public QName getWSDLOperationQName(Packet request) {
        return request.soapAction == null ? null : this.methodHandlers.get(request.soapAction);
    }
}

