/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.keyinfo;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.keyinfo.KeyInfoStrategy;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class DirectReferenceStrategy
extends KeyInfoStrategy {
    X509Certificate cert = null;
    String alias = null;
    boolean forSigning;
    String samlAssertionId = null;
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public DirectReferenceStrategy() {
    }

    public DirectReferenceStrategy(String samlAssertionId) {
        this.samlAssertionId = samlAssertionId;
        this.cert = null;
        this.alias = null;
        this.forSigning = false;
    }

    public DirectReferenceStrategy(String alias, boolean forSigning) {
        this.alias = alias;
        this.forSigning = forSigning;
        this.samlAssertionId = null;
        this.cert = null;
    }

    public void insertKey(SecurityTokenReference tokenRef, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        DirectReference ref = this.getDirectReference(secureMsg, null, null);
        tokenRef.setReference(ref);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId) throws XWSSecurityException {
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        DirectReference ref = this.getDirectReference(secureMsg, x509TokenId, null);
        tokenRef.setReference(ref);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    public void insertKey(KeyInfoHeaderBlock keyInfo, SecurableSoapMessage secureMsg, String x509TokenId, String valueType) throws XWSSecurityException {
        Document ownerDoc = keyInfo.getOwnerDocument();
        SecurityTokenReference tokenRef = new SecurityTokenReference(ownerDoc);
        DirectReference ref = this.getDirectReference(secureMsg, x509TokenId, valueType);
        tokenRef.setReference(ref);
        keyInfo.addSecurityTokenReference(tokenRef);
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public String getAlias() {
        return this.alias;
    }

    private DirectReference getDirectReference(SecurableSoapMessage secureMsg, String x509TokenId, String valueType) throws XWSSecurityException {
        DirectReference ref = new DirectReference();
        if (this.samlAssertionId != null) {
            String uri = "#" + this.samlAssertionId;
            ref.setURI(uri);
            ref.setValueType("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertion-1.1");
        } else {
            if (this.cert == null) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0185_FILTERPARAMETER_NOT_SET("subjectkeyidentifier"), new Object[]{"subjectkeyidentifier"});
                throw new XWSSecurityException("No certificate specified and no default found.");
            }
            if (x509TokenId == null) {
                throw new XWSSecurityException("WSU ID is null");
            }
            String uri = "#" + x509TokenId;
            ref.setURI(uri);
            if (valueType == null || valueType.equals("")) {
                valueType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            }
            ref.setValueType(valueType);
        }
        return ref;
    }
}

