//Copyright Sun Microsystems Inc. 2004 - 2005.

package javax.annotation.security;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

/**
 * Specifies that no security roles are allowed to invoke the specified 
 * method(s) - i.e that the methods are to be excluded from execution in 
 * the J2EE container.
 *
 * @see javax.annotation.security.RolesAllowed
 * @see javax.annotation.security.PermitAll
 * @since Common Annotations 1.0
 */
@Documented
@Retention (RUNTIME)
@Target(METHOD)
public @interface DenyAll {
}
