/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.spi.db;

import com.sun.xml.ws.spi.db.PropertyGetterBase;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodGetter
extends PropertyGetterBase {
    private Method method;

    public MethodGetter(Method m) {
        this.method = m;
        this.type = m.getReturnType();
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public <A> A getAnnotation(Class<A> annotationType) {
        Class<A> c = annotationType;
        return this.method.getAnnotation(c);
    }

    @Override
    public Object get(Object instance) {
        Object[] args = new Object[]{};
        try {
            if (this.method.isAccessible()) {
                return this.method.invoke(instance, args);
            }
            PrivilegedGetter privilegedGetter = new PrivilegedGetter(this.method, instance);
            try {
                AccessController.doPrivileged(privilegedGetter);
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
            return privilegedGetter.value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class PrivilegedGetter
    implements PrivilegedExceptionAction {
        private Object value;
        private Method method;
        private Object instance;

        public PrivilegedGetter(Method m, Object instance) {
            this.method = m;
            this.instance = instance;
        }

        public Object run() throws IllegalAccessException {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            try {
                this.value = this.method.invoke(this.instance, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

