/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common.endpoint;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATImplInjection;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.ParticipantIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.common.client.CoordinatorProxyBuilder;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import com.sun.xml.ws.tx.dev.WSATRuntimeConfig;
import java.util.logging.Level;
import javax.transaction.xa.Xid;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Participant<T>
implements ParticipantIF<T> {
    private static final Class LOGGERCLASS = Participant.class;
    private WebServiceContext m_context;
    private WSATVersion<T> m_version;

    public Participant(WebServiceContext context, WSATVersion<T> version) {
        this.m_context = context;
        this.m_version = version;
    }

    @Override
    public void prepare(T parameters) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare enter:" + parameters);
        }
        CoordinatorIF<T> coordinatorPort = null;
        byte[] tid = null;
        try {
            tid = this.getWSATTid();
            coordinatorPort = this.getCoordinatorPortType();
            String vote = this.getTransactionaService().prepare(tid);
            if (WSATHelper.isDebugEnabled()) {
                this.debug("preparedOperation complete vote:" + vote + " for tid:" + this.stringForTidByteArray(tid));
            }
            if (vote.equals("ReadOnly")) {
                coordinatorPort.readOnlyOperation(this.createNotification());
            } else if (vote.equals("Prepared")) {
                coordinatorPort.preparedOperation(this.createNotification());
            }
        }
        catch (WSATException e) {
            e.printStackTrace();
            if (WSATRuntimeConfig.getInstance().isRollbackOnFailedPrepare()) {
                try {
                    this.log("prepare resulted in exception, issuing rollback for tid:" + this.stringForTidByteArray(tid) + " " + e);
                    this.getTransactionaService().rollback(tid);
                }
                catch (WSATException e1) {
                    e1.printStackTrace();
                }
            }
            this.log("prepare resulted in exception, sending aborted for tid:" + this.stringForTidByteArray(tid) + " " + e);
            if (coordinatorPort != null) {
                coordinatorPort.abortedOperation(this.createNotification());
            }
            this.log("prepare resulted in exception, unable to send abort as coordinatorPort was nullfor tid:" + this.stringForTidByteArray(tid) + " " + e);
            throw new WebServiceException("coordinator port null during prepare");
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("prepare exit:" + parameters + " for tid:" + this.stringForTidByteArray(tid));
        }
    }

    @Override
    public void commit(T parameters) {
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit enter:" + parameters);
        }
        CoordinatorIF<T> coordinatorPort = null;
        boolean isCommitSuccessful = false;
        byte[] tid = null;
        Exception exception = null;
        try {
            tid = this.getWSATTid();
            coordinatorPort = this.getCoordinatorPortTypeForReplyTo();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort:" + coordinatorPort + " for tid:" + this.stringForTidByteArray(tid));
            }
            if (this.isInForeignContextMap()) {
                this.getTransactionaService().commit(tid);
            }
            isCommitSuccessful = true;
            if (WSATHelper.isDebugEnabled()) {
                this.debug("committedOperation complete for tid:" + this.stringForTidByteArray(tid));
            }
        }
        catch (WSATException e) {
            exception = e;
            this.log("WSATException during commit for tid:" + this.stringForTidByteArray(tid) + " " + e);
        }
        catch (IllegalArgumentException e) {
            exception = e;
            this.log("IllegalArgumentException during commit for tid:" + this.stringForTidByteArray(tid) + " " + e);
        }
        if (coordinatorPort == null) {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort null, about to create from replyto for tid:" + this.stringForTidByteArray(tid) + " ");
            }
            coordinatorPort = this.getCoordinatorPortType();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort null attempting to create from replyto coordinatorPort:" + coordinatorPort + "for tid:" + this.stringForTidByteArray(tid));
            }
            if (coordinatorPort == null) {
                throw new WebServiceException("WS-AT coordinator port null during commit for transaction id:" + this.stringForTidByteArray(tid));
            }
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.commit coordinatorPort obtained from replyto:" + coordinatorPort + "for tid:" + this.stringForTidByteArray(tid));
            }
        }
        if (!isCommitSuccessful && WSATHelper.isDebugEnabled()) {
            this.debug("Participant.commit was not successful, presuming previous completion occurred and sending committed for tid:" + this.stringForTidByteArray(tid) + " Exception:" + exception);
        }
        coordinatorPort.committedOperation(this.createNotification());
        if (WSATHelper.isDebugEnabled()) {
            this.debug("committed reply sent, local commit success is " + isCommitSuccessful + " , coordinatorPort:" + coordinatorPort + " for tid:" + this.stringForTidByteArray(tid));
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("commit exit:" + parameters + " for tid:" + this.stringForTidByteArray(tid));
        }
    }

    @Override
    public void rollback(T parameters) {
        byte[] tid;
        CoordinatorIF<T> coordinatorPort;
        block13: {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("rollback parameters:" + parameters);
            }
            coordinatorPort = null;
            tid = null;
            try {
                tid = this.getWSATTid();
                coordinatorPort = this.getCoordinatorPortTypeForReplyTo();
                if (this.isInForeignContextMap()) {
                    this.getTransactionaService().rollback(tid);
                }
                if (WSATHelper.isDebugEnabled()) {
                    this.debug("rollback abortedOperation complete for tid:" + this.stringForTidByteArray(tid));
                }
            }
            catch (IllegalArgumentException e) {
                this.log("rollback IllegalArgumentException for tid:" + this.stringForTidByteArray(tid) + " " + e);
            }
            catch (WSATException e) {
                this.log("rollback WSATException for tid:" + this.stringForTidByteArray(tid) + " " + e);
                if (e.errorCode == -4 || e.errorCode == -6) break block13;
                throw new WebServiceException("Participant.rollback WSATException for tid:" + this.stringForTidByteArray(tid) + " " + e);
            }
        }
        if (coordinatorPort != null) {
            coordinatorPort.abortedOperation(this.createNotification());
        } else {
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.rollback coordinatorPort null attempting to create from replyto for tid:" + this.stringForTidByteArray(tid));
            }
            coordinatorPort = this.getCoordinatorPortType();
            if (WSATHelper.isDebugEnabled()) {
                this.debug("Participant.rollback coordinatorPort null attempting to create from replyto for tid:" + this.stringForTidByteArray(tid) + " coordinatorPort:" + coordinatorPort);
            }
            if (coordinatorPort != null) {
                coordinatorPort.abortedOperation(this.createNotification());
            } else {
                this.log("Coordinator port null during rollback for tid:" + this.stringForTidByteArray(tid) + " about to throw exception/fault.");
                throw new WebServiceException("WS-AT Coordinator port null during rollback for tid:" + this.stringForTidByteArray(tid));
            }
        }
        if (WSATHelper.isDebugEnabled()) {
            this.debug("rollback exit:" + parameters + " for tid:" + this.stringForTidByteArray(tid));
        }
    }

    CoordinatorIF<T> getCoordinatorPortTypeForReplyTo() {
        Header header;
        AddressingVersion av;
        HeaderList headerList = (HeaderList)this.m_context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wsReplyTo = headerList.getReplyTo(av = this.m_version.getAddressingVersion(), this.m_version.getSOPAVersion());
        if (wsReplyTo != null && !wsReplyTo.isNone() && wsReplyTo.isAnonymous() && (header = headerList.get(av.fromTag, true)) != null) {
            try {
                wsReplyTo = header.readAsEPR(av);
            }
            catch (XMLStreamException e) {
                this.log("XMLStreamException while reading ReplyTo EndpointReference:" + e);
            }
        }
        if (wsReplyTo == null || wsReplyTo.isNone() || wsReplyTo.isAnonymous()) {
            return null;
        }
        EndpointReference replyTo = wsReplyTo.toSpec();
        CoordinatorProxyBuilder builder = (CoordinatorProxyBuilder)this.m_version.newCoordinatorProxyBuilder().to(replyTo);
        CoordinatorIF coordinatorPort = builder.build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getCoordinatorPortType replytocoordinatorPort:" + coordinatorPort + "for wsReplyTo/from:" + wsReplyTo + " and replyTo/from:" + replyTo);
        }
        return coordinatorPort;
    }

    TransactionServices getTransactionaService() {
        return WSATHelper.getTransactionServices();
    }

    byte[] getWSATTid() {
        String tidFromHeader = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context).replace("urn:", "").replace("uuid:", "");
        Xid xidFromWebServiceContextHeaderList = TransactionIdHelper.getInstance().wsatid2xid(tidFromHeader);
        byte[] tid = xidFromWebServiceContextHeaderList.getGlobalTransactionId();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getWSATTid tid:" + this.stringForTidByteArray(tid));
        }
        return tid;
    }

    CoordinatorIF<T> getCoordinatorPortType() {
        String txid = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
        Xid xidFromWebServiceContextHeaderList = TransactionIdHelper.getInstance().wsatid2xid(txid);
        EndpointReference parentReference = this.getTransactionaService().getParentReference(xidFromWebServiceContextHeaderList);
        CoordinatorProxyBuilder builder = (CoordinatorProxyBuilder)this.m_version.newCoordinatorProxyBuilder().to(parentReference);
        CoordinatorIF coordinatorPort = builder.build();
        if (WSATHelper.isDebugEnabled()) {
            this.debug("getCoordinatorPortType coordinatorPort:" + coordinatorPort + "for txid:" + txid + " xid:" + xidFromWebServiceContextHeaderList + " parentRef:" + parentReference);
        }
        return coordinatorPort;
    }

    boolean isInForeignContextMap() {
        try {
            String txid = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
            Xid xidFromWebServiceContextHeaderList = TransactionIdHelper.getInstance().wsatid2xid(txid);
            this.getTransactionaService().getParentReference(xidFromWebServiceContextHeaderList);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private String stringForTidByteArray(byte[] tid) {
        return tid == null ? null : new String(tid);
    }

    protected T createNotification() {
        return this.m_version.newNotificationBuilder().build();
    }

    protected WSATHelper getWSATHelper() {
        return this.m_version.getWSATHelper();
    }

    private void log(String msg) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4613_WSAT_PARTICIPANT", msg, null);
        }
    }

    private void debug(String msg) {
        if (this.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, null, msg, null);
        }
    }

    boolean isDebugEnabled() {
        return WSATHelper.isDebugEnabled();
    }
}

