/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.tube;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATImplInjection;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TransactionManagerImpl;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRM;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionIdHelper;
import com.sun.xml.ws.tx.at.tube.TransactionalAttribute;
import com.sun.xml.ws.tx.at.tube.WSATClient;
import com.sun.xml.ws.tx.coord.common.WSATCoordinationContextBuilder;
import com.sun.xml.ws.tx.coord.common.WSCBuilderFactory;
import com.sun.xml.ws.tx.coord.common.types.CoordinationContextIF;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSATClientHelper
implements WSATClient {
    private volatile int counter = 0;
    private static final Class LOGGERCLASS = WSATClientHelper.class;

    @Override
    public List<Header> doHandleRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        try {
            if (TransactionManagerImpl.getInstance().getTransactionManager().getTransaction() == null) {
                return new ArrayList<Header>();
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
            return new ArrayList<Header>();
        }
        List<Header> addedHeaders = this.processTransactionalRequest(transactionalAttribute, map);
        return addedHeaders;
    }

    @Override
    public boolean doHandleResponse(Map<String, Object> map) {
        return this.resumeAndClearXidTxMap(map);
    }

    @Override
    public void doHandleException(Map<String, Object> map) {
        WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4569_INBOUND_APPLICATION_MESSAGE", null, null);
        this.resumeAndClearXidTxMap(map);
    }

    private boolean resumeAndClearXidTxMap(Map<String, Object> map) {
        Transaction transaction;
        Xid xid;
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4569_INBOUND_APPLICATION_MESSAGE", null, null);
        }
        if ((xid = this.getWSATXidFromMap(map)) != null) {
            WSATHelper.getInstance().removeFromXidToTransactionMap(xid);
        }
        return (transaction = this.getWSATTransactionFromMap(map)) == null || this.resume(transaction);
    }

    private Transaction getWSATTransactionFromMap(Map map) {
        Transaction transaction = (Transaction)map.get("wsat.transaction");
        return transaction;
    }

    private Xid getWSATXidFromMap(Map map) {
        Xid xid = (Xid)map.get("wsat.transaction.xid");
        return xid;
    }

    private boolean resume(Transaction transaction) {
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4570_WILL_RESUME_IN_CLIENT_SIDE_HANDLER", new Object[]{transaction, Thread.currentThread()}, (Throwable)null);
        }
        try {
            TransactionManagerImpl.getInstance().getTransactionManager().resume(transaction);
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4571_RESUMED_IN_CLIENT_SIDE_HANDLER", new Object[]{transaction, Thread.currentThread()}, (Throwable)null);
            }
            return true;
        }
        catch (InvalidTransactionException e) {
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4572_INVALID_TRANSACTION_EXCEPTION_IN_CLIENT_SIDE_HANDLER", new Object[]{transaction, Thread.currentThread()}, (Throwable)null);
            }
            try {
                transaction.setRollbackOnly();
            }
            catch (IllegalStateException ex) {
                com.sun.istack.logging.Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, (Throwable)ex);
                return false;
            }
            catch (SystemException ex) {
                com.sun.istack.logging.Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, (Throwable)ex);
                return false;
            }
            return false;
        }
        catch (SystemException e) {
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.SEVERE, "WSAT4573_SYSTEM_EXCEPTION_IN_CLIENT_SIDE_HANDLER", new Object[]{transaction, Thread.currentThread()}, (Throwable)null);
            }
            try {
                transaction.setRollbackOnly();
                return false;
            }
            catch (IllegalStateException ex) {
                com.sun.istack.logging.Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, (Throwable)ex);
                return false;
            }
            catch (SystemException ex) {
                com.sun.istack.logging.Logger.getLogger(WSATClientHelper.class).log(Level.SEVERE, null, (Throwable)ex);
                return false;
            }
        }
    }

    private List<Header> processTransactionalRequest(TransactionalAttribute transactionalAttribute, Map<String, Object> map) {
        Object obj;
        while (!WSATGatewayRM.isReadyForRuntime) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, null, "WS-AT recovery is enabled but WS-AT is not ready for runtime.  Processing WS-AT recovery log files.", null);
            WSATGatewayRM.getInstance().recover();
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        Xid xid = null;
        Object object = obj = (Boolean)map.get("wsat.isColoc") != false ? TransactionManagerImpl.getInstance().getResource("wsat.xid") : null;
        if (obj != null) {
            xid = (Xid)obj;
        }
        if (xid == null) {
            xid = new XidImpl(1234, new String(System.currentTimeMillis() + "-" + this.counter++).getBytes(), new byte[0]);
            TransactionManagerImpl.getInstance().putResource("wsat.xid", xid);
        }
        WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.FINE, null, "WS-AT activityId:" + new String(xid.getBranchQualifier()), null);
        String txId = TransactionIdHelper.getInstance().xid2wsatid(xid);
        long ttl = 0L;
        try {
            ttl = TransactionImportManager.getInstance().getTransactionRemainingTimeout();
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4575_WSAT_INFO_IN_CLIENT_SIDE_HANDLER", new Object[]{txId, ttl, "suspendedTransaction", Thread.currentThread()}, (Throwable)null);
            }
        }
        catch (SystemException ex) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.SEVERE, null, (Object)ex, (Throwable)ex);
        }
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4575_WSAT_INFO_IN_CLIENT_SIDE_HANDLER", new Object[]{txId, ttl, "suspendedTransaction", Thread.currentThread()}, (Throwable)null);
        }
        WSCBuilderFactory builderFactory = WSCBuilderFactory.newInstance(transactionalAttribute.getVersion());
        WSATCoordinationContextBuilder builder = builderFactory.newWSATCoordinationContextBuilder();
        CoordinationContextIF cc = builder.txId(txId).expires(ttl).soapVersion(transactionalAttribute.getSoapVersion()).mustUnderstand(true).build();
        Header coordinationHeader = Headers.create(cc.getJAXBRIContext(), cc.getDelegate());
        headers.add(coordinationHeader);
        if (WSATHelper.isDebugEnabled()) {
            WSATImplInjection.getInstance().getLogging().log(null, LOGGERCLASS, Level.INFO, "WSAT4568_OUTBOUND_APPLICATION_MESSAGE_TRANSACTION_AFTER_ADDING_CONTEXT", "suspendedTransaction", null);
        }
        Transaction suspendedTransaction = this.suspend(map);
        map.put("wsat.transaction.xid", xid);
        WSATHelper.getInstance().putToXidToTransactionMap(xid, suspendedTransaction);
        return headers;
    }

    private Transaction suspend(Map<String, Object> map) {
        Transaction suspendedTransaction = null;
        try {
            suspendedTransaction = TransactionManagerImpl.getInstance().getTransactionManager().suspend();
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4577_ABOUT_TO_SUSPEND_IN_CLIENT_SIDE_HANDLER", new Object[]{suspendedTransaction, Thread.currentThread()}, (Throwable)null);
            }
            map.put("wsat.transaction", suspendedTransaction);
            if (WSATHelper.isDebugEnabled()) {
                WSATImplInjection.getInstance().getLogging().log((Logger)null, LOGGERCLASS, Level.INFO, "WSAT4578_SUSPENDED_IN_CLIENT_SIDE_HANDLER", new Object[]{suspendedTransaction, Thread.currentThread()}, (Throwable)null);
            }
        }
        catch (SystemException e) {
            return null;
        }
        return suspendedTransaction;
    }
}

